/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardOpenOption;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.events.WalSegmentArchivedEvent;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.StorageException;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.CheckpointRecord;
import org.apache.ignite.internal.pagemem.wal.record.MarshalledRecord;
import org.apache.ignite.internal.pagemem.wal.record.SwitchSegmentRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.persistence.DataStorageMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.RandomAccessFileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsFolderSettings;
import org.apache.ignite.internal.processors.cache.persistence.wal.AbstractWalRecordsIterator;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.SegmentArchiveResult;
import org.apache.ignite.internal.processors.cache.persistence.wal.SegmentArchivedMonitor;
import org.apache.ignite.internal.processors.cache.persistence.wal.SegmentEofException;
import org.apache.ignite.internal.processors.cache.persistence.wal.SegmentReservationStorage;
import org.apache.ignite.internal.processors.cache.persistence.wal.SegmentedRingByteBuffer;
import org.apache.ignite.internal.processors.cache.persistence.wal.SingleSegmentLogicalRecordsIterator;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.PureJavaCrc32;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializerFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializerFactoryImpl;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordV1Serializer;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CIX1;
import org.apache.ignite.internal.util.typedef.CO;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileWriteAheadLogManager
extends GridCacheSharedManagerAdapter
implements IgniteWriteAheadLogManager {
    private static final Method force0 = IgniteUtils.findNonPublicMethod(MappedByteBuffer.class, "force0", java.io.FileDescriptor.class, Long.TYPE, Long.TYPE);
    private static final Method mappingOffset = IgniteUtils.findNonPublicMethod(MappedByteBuffer.class, "mappingOffset", new Class[0]);
    private static final Method mappingAddress = IgniteUtils.findNonPublicMethod(MappedByteBuffer.class, "mappingAddress", Long.TYPE);
    private static final Field fd = IgniteUtils.findField(MappedByteBuffer.class, "fd");
    private static final int PAGE_SIZE = GridUnsafe.pageSize();
    private static final FileDescriptor[] EMPTY_DESCRIPTORS = new FileDescriptor[0];
    private static final String WAL_SEGMENT_FILE_EXT = ".wal";
    private static final byte[] FILL_BUF = new byte[0x100000];
    private static final Pattern WAL_NAME_PATTERN = Pattern.compile("\\d{16}\\.wal");
    private static final Pattern WAL_TEMP_NAME_PATTERN = Pattern.compile("\\d{16}\\.wal\\.tmp");
    public static final FileFilter WAL_SEGMENT_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.isDirectory() && WAL_NAME_PATTERN.matcher(file.getName()).matches();
        }
    };
    private static final FileFilter WAL_SEGMENT_TEMP_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.isDirectory() && WAL_TEMP_NAME_PATTERN.matcher(file.getName()).matches();
        }
    };
    private static final Pattern WAL_SEGMENT_FILE_COMPACTED_PATTERN = Pattern.compile("\\d{16}\\.wal\\.zip");
    public static final FileFilter WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.isDirectory() && (WAL_NAME_PATTERN.matcher(file.getName()).matches() || WAL_SEGMENT_FILE_COMPACTED_PATTERN.matcher(file.getName()).matches());
        }
    };
    private static final Pattern WAL_SEGMENT_TEMP_FILE_COMPACTED_PATTERN = Pattern.compile("\\d{16}\\.wal\\.zip\\.tmp");
    private static final FileFilter WAL_SEGMENT_FILE_COMPACTED_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.isDirectory() && WAL_SEGMENT_FILE_COMPACTED_PATTERN.matcher(file.getName()).matches();
        }
    };
    private static final FileFilter WAL_SEGMENT_TEMP_FILE_COMPACTED_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.isDirectory() && WAL_SEGMENT_TEMP_FILE_COMPACTED_PATTERN.matcher(file.getName()).matches();
        }
    };
    private static final int LATEST_SERIALIZER_VERSION = 2;
    private static final int BUF_SIZE = 0x100000;
    private final boolean mmap = IgniteSystemProperties.getBoolean("IGNITE_WAL_MMAP", true);
    private static final AtomicLongFieldUpdater<FileWriteHandle> WRITTEN_UPD = AtomicLongFieldUpdater.newUpdater(FileWriteHandle.class, "written");
    private final ThreadLocal<Boolean> interrupted = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private final boolean alwaysWriteFullPages;
    private final long maxWalSegmentSize;
    private final WALMode mode;
    private final long flushFreq;
    private final long fsyncDelay;
    private final DataStorageConfiguration dsCfg;
    private final GridEventStorageManager evt;
    private IgniteConfiguration igCfg;
    private DataStorageMetricsImpl metrics;
    private File walWorkDir;
    private File walArchiveDir;
    private RecordSerializer serializer;
    private final int serializerVer = IgniteSystemProperties.getInteger("IGNITE_WAL_SERIALIZER_VERSION", 2);
    private volatile long lastTruncatedArchiveIdx = -1L;
    private FileIOFactory ioFactory;
    private final SegmentArchivedMonitor archivedMonitor = new SegmentArchivedMonitor();
    private final SegmentReservationStorage reservationStorage = new SegmentReservationStorage();
    private static final AtomicReferenceFieldUpdater<FileWriteAheadLogManager, FileWriteHandle> CURR_HND_UPD = AtomicReferenceFieldUpdater.newUpdater(FileWriteAheadLogManager.class, FileWriteHandle.class, "currHnd");
    @Nullable
    private volatile FileArchiver archiver;
    private volatile FileCompressor compressor;
    private volatile FileDecompressor decompressor;
    private final ThreadLocal<WALPointer> lastWALPtr = new ThreadLocal();
    private volatile FileWriteHandle currHnd;
    private final long walAutoArchiveAfterInactivity;
    private AtomicLong lastRecordLoggedMs = new AtomicLong();
    @Nullable
    private volatile GridTimeoutProcessor.CancelableTask backgroundFlushSchedule;
    @Nullable
    private volatile GridTimeoutObject nextAutoArchiveTimeoutObj;
    private WALWriter walWriter;
    @Nullable
    private volatile IgniteInClosure<FileIO> createWalFileListener;

    public FileWriteAheadLogManager(@NotNull GridKernalContext ctx) {
        this.igCfg = ctx.config();
        DataStorageConfiguration dsCfg = this.igCfg.getDataStorageConfiguration();
        assert (dsCfg != null);
        this.dsCfg = dsCfg;
        this.maxWalSegmentSize = dsCfg.getWalSegmentSize();
        this.mode = dsCfg.getWalMode();
        this.flushFreq = dsCfg.getWalFlushFrequency();
        this.fsyncDelay = dsCfg.getWalFsyncDelayNanos();
        this.alwaysWriteFullPages = dsCfg.isAlwaysWriteFullPages();
        this.ioFactory = new RandomAccessFileIOFactory();
        this.walAutoArchiveAfterInactivity = dsCfg.getWalAutoArchiveAfterInactivity();
        this.evt = ctx.event();
    }

    public void setFileIOFactory(FileIOFactory ioFactory) {
        this.ioFactory = ioFactory;
    }

    @Override
    public void start0() throws IgniteCheckedException {
        if (!this.cctx.kernalContext().clientNode()) {
            IgniteBiTuple<Long, Long> tup;
            PdsFolderSettings resolveFolders = this.cctx.kernalContext().pdsFolderResolver().resolveFolders();
            this.checkWalConfiguration();
            final File walWorkDir0 = this.walWorkDir = this.initDirectory(this.dsCfg.getWalPath(), "db/wal", resolveFolders.folderName(), "write ahead log work directory");
            final File walArchiveDir0 = this.walArchiveDir = this.initDirectory(this.dsCfg.getWalArchivePath(), "db/wal/archive", resolveFolders.folderName(), "write ahead log archive directory");
            this.serializer = new RecordSerializerFactoryImpl(this.cctx).createSerializer(this.serializerVer);
            GridCacheDatabaseSharedManager dbMgr = (GridCacheDatabaseSharedManager)this.cctx.database();
            this.metrics = dbMgr.persistentStoreMetricsImpl();
            this.checkOrPrepareFiles();
            if (this.metrics != null) {
                this.metrics.setWalSizeProvider((IgniteOutClosure<Long>)new CO<Long>(){

                    @Override
                    public Long apply() {
                        long size = 0L;
                        for (File f : walWorkDir0.listFiles()) {
                            size += f.length();
                        }
                        for (File f : walArchiveDir0.listFiles()) {
                            size += f.length();
                        }
                        return size;
                    }
                });
            }
            this.lastTruncatedArchiveIdx = (tup = this.scanMinMaxArchiveIndices()) == null ? -1L : tup.get1() - 1L;
            long lastAbsArchivedIdx = tup == null ? -1L : tup.get2();
            this.archiver = this.isArchiverEnabled() ? new FileArchiver(lastAbsArchivedIdx) : null;
            if (lastAbsArchivedIdx > 0L) {
                this.archivedMonitor.setLastArchivedAbsoluteIndex(lastAbsArchivedIdx);
            }
            if (this.dsCfg.isWalCompactionEnabled()) {
                this.compressor = new FileCompressor();
                this.decompressor = new FileDecompressor();
                if (!this.cctx.kernalContext().clientNode()) {
                    this.decompressor.start();
                }
            }
            if (this.mode != WALMode.NONE) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Started write-ahead log manager [mode=" + (Object)((Object)this.mode) + ']');
                }
            } else {
                U.quietAndWarn(this.log, "Started write-ahead log manager in NONE mode, persisted data may be lost in a case of unexpected node failure. Make sure to deactivate the cluster before shutdown.");
            }
        }
    }

    private boolean isArchiverEnabled() {
        if (this.walArchiveDir != null && this.walWorkDir != null) {
            return !this.walArchiveDir.equals(this.walWorkDir);
        }
        return !new File(this.dsCfg.getWalArchivePath()).equals(new File(this.dsCfg.getWalPath()));
    }

    public Collection<File> getAndReserveWalFiles(FileWALPointer low, FileWALPointer high) throws IgniteCheckedException {
        long awaitIdx = high.index() - 1L;
        this.archivedMonitor.awaitSegmentArchived(awaitIdx);
        if (!this.reserve(low)) {
            throw new IgniteCheckedException("WAL archive segment has been deleted [idx=" + low.index() + "]");
        }
        ArrayList<File> res = new ArrayList<File>();
        for (long i = low.index(); i < high.index(); ++i) {
            String segmentName = FileDescriptor.fileName(i);
            File file = new File(this.walArchiveDir, segmentName);
            File fileZip = new File(this.walArchiveDir, segmentName + ".zip");
            if (file.exists()) {
                res.add(file);
                continue;
            }
            if (fileZip.exists()) {
                res.add(fileZip);
                continue;
            }
            if (!this.log.isInfoEnabled()) break;
            this.log.info("Segment not found: " + file.getName() + "/" + fileZip.getName());
            this.log.info("Stopped iteration on idx: " + i);
            break;
        }
        return res;
    }

    private void checkWalConfiguration() throws IgniteCheckedException {
        if (this.dsCfg.getWalPath() == null ^ this.dsCfg.getWalArchivePath() == null) {
            throw new IgniteCheckedException("Properties should be either both specified or both null [walStorePath = " + this.dsCfg.getWalPath() + ", walArchivePath = " + this.dsCfg.getWalArchivePath() + "]");
        }
    }

    @Override
    protected void stop0(boolean cancel) {
        GridTimeoutObject timeoutObj;
        GridTimeoutProcessor.CancelableTask schedule = this.backgroundFlushSchedule;
        if (schedule != null) {
            schedule.close();
        }
        if ((timeoutObj = this.nextAutoArchiveTimeoutObj) != null) {
            this.cctx.time().removeTimeoutObject(timeoutObj);
        }
        FileWriteHandle currHnd = this.currentHandle();
        try {
            if (this.mode == WALMode.BACKGROUND && currHnd != null) {
                currHnd.flush(null);
            }
            if (currHnd != null) {
                currHnd.close(false);
            }
            if (this.walWriter != null) {
                this.walWriter.shutdown();
            }
            if (this.archiver != null) {
                this.archiver.shutdown();
            }
            if (this.compressor != null) {
                this.compressor.shutdown();
            }
            if (this.decompressor != null) {
                this.decompressor.shutdown();
            }
        }
        catch (Exception e) {
            U.error(this.log, "Failed to gracefully close WAL segment: " + this.currHnd.fileIO, e);
        }
    }

    @Override
    public void onActivate(GridKernalContext kctx) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Activated file write ahead log manager [nodeId=" + this.cctx.localNodeId() + " topVer=" + this.cctx.discovery().topologyVersionEx() + " ]");
        }
        this.start0();
        if (!this.cctx.kernalContext().clientNode()) {
            if (this.isArchiverEnabled()) {
                assert (this.archiver != null);
                this.archiver.start();
            }
            if (this.compressor != null) {
                this.compressor.start();
            }
        }
    }

    @Override
    public void onDeActivate(GridKernalContext kctx) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("DeActivate file write ahead log [nodeId=" + this.cctx.localNodeId() + " topVer=" + this.cctx.discovery().topologyVersionEx() + " ]");
        }
        this.stop0(true);
        this.currHnd = null;
    }

    @Override
    public boolean isAlwaysWriteFullPages() {
        return this.alwaysWriteFullPages;
    }

    @Override
    public boolean isFullSync() {
        return this.mode == WALMode.FSYNC;
    }

    @Override
    public void resumeLogging(WALPointer lastPtr) throws IgniteCheckedException {
        try {
            assert (this.currHnd == null);
            assert (lastPtr == null || lastPtr instanceof FileWALPointer);
            FileWALPointer filePtr = (FileWALPointer)lastPtr;
            this.walWriter = new WALWriter();
            if (!this.mmap) {
                this.walWriter.start();
            }
            this.currHnd = this.restoreWriteHandle(filePtr);
            if (filePtr == null) {
                this.currHnd.writeHeader();
            }
            if (this.currHnd.serializer.version() != this.serializer.version()) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Record serializer version change detected, will start logging with a new WAL record serializer to a new WAL segment [curFile=" + this.currHnd + ", newVer=" + this.serializer.version() + ", oldVer=" + this.currHnd.serializer.version() + ']');
                }
                this.rollOver(this.currHnd);
            }
            this.currHnd.resume = false;
            if (this.mode == WALMode.BACKGROUND) {
                this.backgroundFlushSchedule = this.cctx.time().schedule(new Runnable(){

                    @Override
                    public void run() {
                        FileWriteAheadLogManager.this.doFlush();
                    }
                }, this.flushFreq, this.flushFreq);
            }
            if (this.walAutoArchiveAfterInactivity > 0L) {
                this.scheduleNextInactivityPeriodElapsedCheck();
            }
        }
        catch (StorageException e) {
            throw new IgniteCheckedException(e);
        }
    }

    private void scheduleNextInactivityPeriodElapsedCheck() {
        long lastRecMs = this.lastRecordLoggedMs.get();
        final long nextPossibleAutoArchive = (lastRecMs <= 0L ? U.currentTimeMillis() : lastRecMs) + this.walAutoArchiveAfterInactivity;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Schedule WAL rollover check at " + new Time(nextPossibleAutoArchive).toString());
        }
        this.nextAutoArchiveTimeoutObj = new GridTimeoutObject(){
            private final IgniteUuid id = IgniteUuid.randomUuid();

            @Override
            public IgniteUuid timeoutId() {
                return this.id;
            }

            @Override
            public long endTime() {
                return nextPossibleAutoArchive;
            }

            @Override
            public void onTimeout() {
                if (FileWriteAheadLogManager.this.log.isDebugEnabled()) {
                    FileWriteAheadLogManager.this.log.debug("Checking if WAL rollover required (" + new Time(U.currentTimeMillis()).toString() + ")");
                }
                FileWriteAheadLogManager.this.checkWalRolloverRequiredDuringInactivityPeriod();
                FileWriteAheadLogManager.this.scheduleNextInactivityPeriodElapsedCheck();
            }
        };
        this.cctx.time().addTimeoutObject(this.nextAutoArchiveTimeoutObj);
    }

    @Override
    public int serializerVersion() {
        return this.serializerVer;
    }

    private void checkWalRolloverRequiredDuringInactivityPeriod() {
        if (this.walAutoArchiveAfterInactivity <= 0L) {
            return;
        }
        long lastRecMs = this.lastRecordLoggedMs.get();
        if (lastRecMs == 0L) {
            return;
        }
        long elapsedMs = U.currentTimeMillis() - lastRecMs;
        if (elapsedMs <= this.walAutoArchiveAfterInactivity) {
            return;
        }
        if (!this.lastRecordLoggedMs.compareAndSet(lastRecMs, 0L)) {
            return;
        }
        FileWriteHandle handle = this.currentHandle();
        try {
            handle.buf.close();
            this.rollOver(handle);
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Unable to perform segment rollover: " + e.getMessage(), e);
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
        }
    }

    @Override
    public WALPointer log(WALRecord rec) throws IgniteCheckedException, StorageException {
        if (this.serializer == null || this.mode == WALMode.NONE) {
            return null;
        }
        FileWriteHandle currWrHandle = this.currentHandle();
        if (currWrHandle == null) {
            return null;
        }
        rec.size(this.serializer.size(rec));
        do {
            WALPointer ptr;
            if (rec.rollOver()) {
                assert (this.cctx.database().checkpointLockIsHeldByThread());
                long idx = currWrHandle.idx;
                currWrHandle.buf.close();
                currWrHandle = this.rollOver(currWrHandle);
                if (this.log != null && this.log.isDebugEnabled()) {
                    this.log.debug("Rollover segment [" + idx + " to " + currWrHandle.idx + "], recordType=" + (Object)((Object)rec.type()));
                }
            }
            if ((ptr = currWrHandle.addRecord(rec)) != null) {
                this.metrics.onWalRecordLogged();
                this.lastWALPtr.set(ptr);
                if (this.walAutoArchiveAfterInactivity > 0L) {
                    this.lastRecordLoggedMs.set(U.currentTimeMillis());
                }
                return ptr;
            }
            currWrHandle = this.rollOver(currWrHandle);
            this.checkNode();
        } while (!this.isStopping());
        throw new IgniteCheckedException("Stopping.");
    }

    @Override
    public void flush(WALPointer ptr, boolean explicitFsync) throws IgniteCheckedException, StorageException {
        if (this.serializer == null || this.mode == WALMode.NONE) {
            return;
        }
        FileWriteHandle cur = this.currentHandle();
        if (cur == null) {
            return;
        }
        FileWALPointer filePtr = (FileWALPointer)(ptr == null ? this.lastWALPtr.get() : ptr);
        if (this.mode == WALMode.LOG_ONLY) {
            cur.flushOrWait(filePtr);
        }
        if (!explicitFsync && this.mode != WALMode.FSYNC) {
            return;
        }
        if (filePtr != null && !cur.needFsync(filePtr)) {
            return;
        }
        cur.fsync(filePtr);
    }

    @Override
    public WALIterator replay(WALPointer start) throws IgniteCheckedException, StorageException {
        assert (start == null || start instanceof FileWALPointer) : "Invalid start pointer: " + start;
        FileWriteHandle hnd = this.currentHandle();
        FileWALPointer end = null;
        if (hnd != null) {
            end = hnd.position();
        }
        return new RecordsIterator(this.cctx, this.walWorkDir, this.walArchiveDir, (FileWALPointer)start, end, this.dsCfg, new RecordSerializerFactoryImpl(this.cctx), this.ioFactory, this.archiver, this.decompressor, this.log);
    }

    @Override
    public boolean reserve(WALPointer start) throws IgniteCheckedException {
        assert (start != null && start instanceof FileWALPointer) : "Invalid start pointer: " + start;
        if (this.mode == WALMode.NONE) {
            return false;
        }
        this.reservationStorage.reserve(((FileWALPointer)start).index());
        if (!this.hasIndex(((FileWALPointer)start).index())) {
            this.reservationStorage.release(((FileWALPointer)start).index());
            return false;
        }
        return true;
    }

    @Override
    public void release(WALPointer start) throws IgniteCheckedException {
        assert (start != null && start instanceof FileWALPointer) : "Invalid start pointer: " + start;
        if (this.mode == WALMode.NONE) {
            return;
        }
        this.reservationStorage.release(((FileWALPointer)start).index());
    }

    private boolean hasIndex(long absIdx) {
        boolean inArchive;
        String segmentName = FileDescriptor.fileName(absIdx);
        String zipSegmentName = FileDescriptor.fileName(absIdx) + ".zip";
        boolean bl = inArchive = new File(this.walArchiveDir, segmentName).exists() || new File(this.walArchiveDir, zipSegmentName).exists();
        if (inArchive) {
            return true;
        }
        if (absIdx <= this.lastArchivedIndex()) {
            return false;
        }
        FileWriteHandle cur = this.currHnd;
        return cur != null && cur.idx >= absIdx;
    }

    @Override
    public int truncate(WALPointer low, WALPointer high) {
        if (high == null) {
            return 0;
        }
        assert (high instanceof FileWALPointer) : high;
        FileWALPointer lowPtr = (FileWALPointer)low;
        FileWALPointer highPtr = (FileWALPointer)high;
        FileDescriptor[] descs = FileWriteAheadLogManager.scan(this.walArchiveDir.listFiles(WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER));
        int deleted = 0;
        for (FileDescriptor desc : descs) {
            long lastArchived;
            if (lowPtr != null && desc.idx < lowPtr.index()) continue;
            if (this.segmentReservedOrLocked(desc.idx)) {
                return deleted;
            }
            long archivedAbsIdx = this.archivedMonitor.lastArchivedAbsoluteIndex();
            long l = lastArchived = archivedAbsIdx >= 0L ? archivedAbsIdx : this.lastArchivedIndex();
            if (desc.idx >= highPtr.index() || desc.idx >= lastArchived) continue;
            if (!desc.file.delete()) {
                U.warn(this.log, "Failed to remove obsolete WAL segment (make sure the process has enough rights): " + desc.file.getAbsolutePath());
            } else {
                ++deleted;
            }
            if (this.lastTruncatedArchiveIdx >= desc.idx) continue;
            this.lastTruncatedArchiveIdx = desc.idx;
        }
        return deleted;
    }

    private boolean segmentReservedOrLocked(long absIdx) {
        FileArchiver archiver0 = this.archiver;
        return archiver0 != null && archiver0.locked(absIdx) || this.reservationStorage.reserved(absIdx);
    }

    @Override
    public void allowCompressionUntil(WALPointer ptr) {
        if (this.compressor != null) {
            this.compressor.allowCompressionUntil(((FileWALPointer)ptr).index());
        }
    }

    @Override
    public int walArchiveSegments() {
        long lastTruncated = this.lastTruncatedArchiveIdx;
        long lastArchived = this.archivedMonitor.lastArchivedAbsoluteIndex();
        if (lastArchived == -1L) {
            return 0;
        }
        int res = (int)(lastArchived - lastTruncated);
        return res >= 0 ? res : 0;
    }

    @Override
    public boolean reserved(WALPointer ptr) {
        FileWALPointer fPtr = (FileWALPointer)ptr;
        return this.segmentReservedOrLocked(fPtr.index());
    }

    @Override
    public boolean disabled(int grpId) {
        CacheGroupContext ctx = this.cctx.cache().cacheGroup(grpId);
        return ctx != null && !ctx.walEnabled();
    }

    private long lastArchivedIndex() {
        long lastIdx = -1L;
        for (File file : this.walArchiveDir.listFiles(WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER)) {
            try {
                long idx = Long.parseLong(file.getName().substring(0, 16));
                lastIdx = Math.max(lastIdx, idx);
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                // empty catch block
            }
        }
        return lastIdx;
    }

    private IgniteBiTuple<Long, Long> scanMinMaxArchiveIndices() {
        TreeSet<Long> archiveIndices = new TreeSet<Long>();
        for (File file : this.walArchiveDir.listFiles(WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER)) {
            try {
                long idx = Long.parseLong(file.getName().substring(0, 16));
                archiveIndices.add(idx);
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                // empty catch block
            }
        }
        if (archiveIndices.isEmpty()) {
            return null;
        }
        Long min = (Long)archiveIndices.first();
        Long max = (Long)archiveIndices.last();
        if (max - min == (long)(archiveIndices.size() - 1)) {
            return F.t(min, max);
        }
        for (Long idx : archiveIndices.descendingSet()) {
            if (archiveIndices.contains(idx - 1L)) continue;
            return F.t(idx, max);
        }
        throw new IllegalStateException("Should never happen if TreeSet is valid.");
    }

    private File initDirectory(String cfg, String defDir, String consId, String msg) throws IgniteCheckedException {
        File workDir0;
        File dir = cfg != null ? ((workDir0 = new File(cfg)).isAbsolute() ? new File(workDir0, consId) : new File(U.resolveWorkDirectory(this.igCfg.getWorkDirectory(), cfg, false), consId)) : new File(U.resolveWorkDirectory(this.igCfg.getWorkDirectory(), defDir, false), consId);
        U.ensureDirectory(dir, msg, this.log);
        return dir;
    }

    private FileWriteHandle currentHandle() {
        return this.currHnd;
    }

    private FileWriteHandle rollOver(FileWriteHandle cur) throws StorageException, IgniteCheckedException {
        FileWriteHandle hnd = this.currentHandle();
        if (hnd != cur) {
            return hnd;
        }
        if (hnd.close(true)) {
            if (this.metrics.metricsEnabled()) {
                this.metrics.onWallRollOver();
            }
            FileWriteHandle next = this.initNextWriteHandle(cur);
            next.writeHeader();
            boolean swapped = CURR_HND_UPD.compareAndSet(this, hnd, next);
            assert (swapped) : "Concurrent updates on rollover are not allowed";
            if (this.walAutoArchiveAfterInactivity > 0L) {
                this.lastRecordLoggedMs.set(0L);
            }
            hnd.signalNextAvailable();
        } else {
            hnd.awaitNext();
        }
        return this.currentHandle();
    }

    private FileWriteHandle restoreWriteHandle(FileWALPointer lastReadPtr) throws IgniteCheckedException {
        long absIdx = lastReadPtr == null ? 0L : lastReadPtr.index();
        FileArchiver archiver0 = this.archiver;
        long segNo = archiver0 == null ? absIdx : absIdx % (long)this.dsCfg.getWalSegments();
        File curFile = new File(this.walWorkDir, FileDescriptor.fileName(segNo));
        int off = lastReadPtr == null ? 0 : lastReadPtr.fileOffset();
        int len = lastReadPtr == null ? 0 : lastReadPtr.length();
        try {
            FileIO fileIO = this.ioFactory.create(curFile);
            IgniteInClosure<FileIO> lsnr = this.createWalFileListener;
            if (lsnr != null) {
                lsnr.apply(fileIO);
            }
            try {
                SegmentedRingByteBuffer rbuf;
                int serVer = this.serializerVer;
                if (lastReadPtr != null) {
                    try {
                        serVer = RecordV1Serializer.readSegmentHeader(fileIO, absIdx).getSerializerVersion();
                    }
                    catch (EOFException | SegmentEofException ignore) {
                        serVer = this.serializerVer;
                    }
                }
                RecordSerializer ser = new RecordSerializerFactoryImpl(this.cctx).createSerializer(serVer);
                if (this.log.isInfoEnabled()) {
                    this.log.info("Resuming logging to WAL segment [file=" + curFile.getAbsolutePath() + ", offset=" + off + ", ver=" + serVer + ']');
                }
                if (this.mmap) {
                    try {
                        MappedByteBuffer buf = fileIO.map((int)this.maxWalSegmentSize);
                        rbuf = new SegmentedRingByteBuffer(buf, this.metrics);
                    }
                    catch (IOException e) {
                        throw new IgniteCheckedException(e);
                    }
                } else {
                    rbuf = new SegmentedRingByteBuffer(this.dsCfg.getWalBufferSize(), this.maxWalSegmentSize, SegmentedRingByteBuffer.BufferMode.DIRECT, this.metrics);
                }
                if (lastReadPtr != null) {
                    rbuf.init(lastReadPtr.fileOffset() + lastReadPtr.length());
                }
                FileWriteHandle hnd = new FileWriteHandle(fileIO, absIdx, off + len, true, ser, rbuf);
                if (archiver0 != null) {
                    archiver0.currentWalIndex(absIdx);
                } else {
                    this.archivedMonitor.setLastArchivedAbsoluteIndex(absIdx - 1L);
                }
                return hnd;
            }
            catch (IOException | IgniteCheckedException e) {
                fileIO.close();
                throw e;
            }
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to restore WAL write handle: " + curFile.getAbsolutePath(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileWriteHandle initNextWriteHandle(FileWriteHandle cur) throws StorageException, IgniteCheckedException {
        try {
            FileWriteHandle hnd;
            File nextFile = this.pollNextFile(cur.idx);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Switching to a new WAL segment: " + nextFile.getAbsolutePath());
            }
            SegmentedRingByteBuffer rbuf = null;
            FileIO fileIO = null;
            boolean interrupted = this.interrupted.get();
            while (true) {
                try {
                    fileIO = this.ioFactory.create(nextFile);
                    IgniteInClosure<FileIO> lsnr = this.createWalFileListener;
                    if (lsnr != null) {
                        lsnr.apply(fileIO);
                    }
                    if (this.mmap) {
                        MappedByteBuffer buf = fileIO.map((int)this.maxWalSegmentSize);
                        rbuf = new SegmentedRingByteBuffer(buf, this.metrics);
                    } else {
                        rbuf = cur.buf.reset();
                    }
                    hnd = new FileWriteHandle(fileIO, cur.idx + 1L, 0L, false, this.serializer, rbuf);
                    if (!interrupted) break;
                    Thread.currentThread().interrupt();
                }
                catch (ClosedByInterruptException ignore) {
                    interrupted = true;
                    Thread.interrupted();
                    if (fileIO != null) {
                        try {
                            fileIO.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        fileIO = null;
                    }
                    if (rbuf == null) continue;
                    rbuf.free();
                    rbuf = null;
                    continue;
                }
                finally {
                    this.interrupted.set(false);
                    continue;
                }
                break;
            }
            return hnd;
        }
        catch (IOException e) {
            StorageException se = new StorageException("Unable to initialize WAL segment", e);
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, se));
            throw se;
        }
    }

    private void checkOrPrepareFiles() throws IgniteCheckedException {
        File[] tmpFiles = this.walWorkDir.listFiles(WAL_SEGMENT_TEMP_FILE_FILTER);
        if (!F.isEmpty(tmpFiles)) {
            for (File tmp : tmpFiles) {
                boolean deleted = tmp.delete();
                if (deleted) continue;
                throw new IgniteCheckedException("Failed to delete previously created temp file (make sure Ignite process has enough rights): " + tmp.getAbsolutePath());
            }
        }
        File[] allFiles = this.walWorkDir.listFiles(WAL_SEGMENT_FILE_FILTER);
        if (this.isArchiverEnabled() && allFiles.length != 0 && allFiles.length > this.dsCfg.getWalSegments()) {
            throw new IgniteCheckedException("Failed to initialize wal (work directory contains incorrect number of segments) [cur=" + allFiles.length + ", expected=" + this.dsCfg.getWalSegments() + ']');
        }
        if (allFiles.length == 0) {
            File first = new File(this.walWorkDir, FileDescriptor.fileName(0L));
            this.createFile(first);
        } else {
            this.checkFiles(0, false, null, null);
        }
    }

    private void formatFile(File file) throws IgniteCheckedException {
        this.formatFile(file, this.dsCfg.getWalSegmentSize());
    }

    private void formatFile(File file, int bytesCntToFormat) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Formatting file [exists=" + file.exists() + ", file=" + file.getAbsolutePath() + ']');
        }
        try (FileIO fileIO = this.ioFactory.create(file, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);){
            if (this.mode == WALMode.FSYNC) {
                int toWrite;
                for (int left = bytesCntToFormat; left > 0; left -= toWrite) {
                    toWrite = Math.min(FILL_BUF.length, left);
                    fileIO.write(FILL_BUF, 0, toWrite);
                }
                fileIO.force();
            } else {
                fileIO.clear();
            }
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to format WAL segment file: " + file.getAbsolutePath(), e);
        }
    }

    private void createFile(File file) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating new file [exists=" + file.exists() + ", file=" + file.getAbsolutePath() + ']');
        }
        File tmp = new File(file.getParent(), file.getName() + ".tmp");
        this.formatFile(tmp);
        try {
            Files.move(tmp.toPath(), file.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to move temp file to a regular WAL segment file: " + file.getAbsolutePath(), e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Created WAL segment [file=" + file.getAbsolutePath() + ", size=" + file.length() + ']');
        }
    }

    private File pollNextFile(long curIdx) throws IgniteCheckedException {
        FileArchiver archiver0 = this.archiver;
        if (archiver0 == null) {
            this.archivedMonitor.setLastArchivedAbsoluteIndex(curIdx);
            return new File(this.walWorkDir, FileDescriptor.fileName(curIdx + 1L));
        }
        long absNextIdx = archiver0.nextAbsoluteSegmentIndex(curIdx);
        long segmentIdx = absNextIdx % (long)this.dsCfg.getWalSegments();
        return new File(this.walWorkDir, FileDescriptor.fileName(segmentIdx));
    }

    public static FileDescriptor[] scan(File[] allFiles) {
        if (allFiles == null) {
            return EMPTY_DESCRIPTORS;
        }
        Object[] descs = new FileDescriptor[allFiles.length];
        for (int i = 0; i < allFiles.length; ++i) {
            File f = allFiles[i];
            descs[i] = new FileDescriptor(f);
        }
        Arrays.sort(descs);
        return descs;
    }

    private void checkNode() throws StorageException {
        if (this.cctx.kernalContext().invalid()) {
            throw new StorageException("Failed to perform WAL operation (environment was invalidated by a previous error)");
        }
    }

    public void setCreateWalFileListener(@Nullable IgniteInClosure<FileIO> createWalFileListener) {
        this.createWalFileListener = createWalFileListener;
    }

    public long maxWalSegmentSize() {
        return this.maxWalSegmentSize;
    }

    private void checkFiles(int startWith, boolean create, @Nullable IgnitePredicate<Integer> p, @Nullable IgniteInClosure<Integer> completionCallback) throws IgniteCheckedException {
        for (int i = startWith; i < this.dsCfg.getWalSegments() && (p == null || p.apply(i)); ++i) {
            File checkFile = new File(this.walWorkDir, FileDescriptor.fileName(i));
            if (checkFile.exists()) {
                if (checkFile.isDirectory()) {
                    throw new IgniteCheckedException("Failed to initialize WAL log segment (a directory with the same name already exists): " + checkFile.getAbsolutePath());
                }
                if (checkFile.length() != (long)this.dsCfg.getWalSegmentSize() && this.mode == WALMode.FSYNC) {
                    throw new IgniteCheckedException("Failed to initialize WAL log segment (WAL segment size change is not supported in 'DEFAULT' WAL mode) [filePath=" + checkFile.getAbsolutePath() + ", fileSize=" + checkFile.length() + ", configSize=" + this.dsCfg.getWalSegments() + ']');
                }
            } else if (create) {
                this.createFile(checkFile);
            }
            if (completionCallback == null) continue;
            completionCallback.apply(i);
        }
    }

    @NotNull
    private static ByteBuffer prepareSerializerVersionBuffer(long idx, int ver, boolean compacted, ByteBuffer buf) {
        buf.put((byte)(WALRecord.RecordType.HEADER_RECORD.ordinal() + 1));
        RecordV1Serializer.putPosition(buf, new FileWALPointer(idx, 0, 0));
        buf.putLong(compacted ? 5622654036411574606L : -5705984118950656934L);
        buf.putInt(ver);
        if (!RecordV1Serializer.skipCrc) {
            int curPos = buf.position();
            buf.position(0);
            int crcVal = PureJavaCrc32.calcCrc32(buf, curPos);
            buf.putInt(crcVal);
        } else {
            buf.putInt(0);
        }
        buf.position(0);
        return buf;
    }

    private void doFlush() {
        FileWriteHandle hnd = this.currentHandle();
        try {
            hnd.flush(null);
        }
        catch (Exception e) {
            U.warn(this.log, "Failed to flush WAL record queue", e);
        }
    }

    public static FileDescriptor[] loadFileDescriptors(@NotNull File walFilesDir) throws IgniteCheckedException {
        File[] files = walFilesDir.listFiles(WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER);
        if (files == null) {
            throw new IgniteCheckedException("WAL files directory does not not denote a directory, or if an I/O error occurs: [" + walFilesDir.getAbsolutePath() + "]");
        }
        return FileWriteAheadLogManager.scan(files);
    }

    private class WALWriter
    extends Thread {
        private static final long UNCONDITIONAL_FLUSH = -1L;
        private static final long FILE_CLOSE = -2L;
        private static final long FILE_FORCE = -3L;
        private volatile boolean shutdown;
        private volatile Throwable err;
        final Map<Thread, Long> waiters;

        WALWriter() {
            super("wal-write-worker%" + FileWriteAheadLogManager.this.cctx.igniteInstanceName());
            this.waiters = new ConcurrentHashMap<Thread, Long>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Throwable err = null;
            try {
                while (!this.shutdown && !Thread.currentThread().isInterrupted()) {
                    List<SegmentedRingByteBuffer.ReadSegment> segs;
                    while (this.waiters.isEmpty()) {
                        if (!this.shutdown) {
                            LockSupport.park();
                            continue;
                        }
                        this.unparkWaiters(Long.MAX_VALUE);
                        return;
                    }
                    Long pos = null;
                    for (Long val : this.waiters.values()) {
                        if (val <= Long.MIN_VALUE) continue;
                        pos = val;
                    }
                    if (pos == null) continue;
                    if (pos < -1L) {
                        try {
                            assert (pos == -2L || pos == -3L) : pos;
                            if (pos == -2L) {
                                ((FileWriteAheadLogManager)FileWriteAheadLogManager.this).currHnd.fileIO.close();
                            } else if (pos == -3L) {
                                ((FileWriteAheadLogManager)FileWriteAheadLogManager.this).currHnd.fileIO.force();
                            }
                        }
                        catch (IOException e) {
                            FileWriteAheadLogManager.this.log.error("Exception in WAL writer thread: ", e);
                            err = e;
                            this.unparkWaiters(Long.MAX_VALUE);
                            if (err == null && !this.shutdown) {
                                err = new IllegalStateException("Thread " + this.getName() + " is terminated unexpectedly");
                            }
                            if (err instanceof OutOfMemoryError) {
                                FileWriteAheadLogManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, err));
                            } else if (err != null) {
                                FileWriteAheadLogManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err));
                            }
                            return;
                        }
                        this.unparkWaiters(pos);
                    }
                    if ((segs = FileWriteAheadLogManager.this.currentHandle().buf.poll(pos)) == null) {
                        this.unparkWaiters(pos);
                        continue;
                    }
                    for (int i = 0; i < segs.size(); ++i) {
                        long p;
                        SegmentedRingByteBuffer.ReadSegment seg = segs.get(i);
                        try {
                            this.writeBuffer(seg.position(), seg.buffer());
                            seg.release();
                            p = pos <= -1L || err != null ? Long.MAX_VALUE : ((FileWriteAheadLogManager)FileWriteAheadLogManager.this).currentHandle().written;
                        }
                        catch (Throwable e) {
                            try {
                                FileWriteAheadLogManager.this.log.error("Exception in WAL writer thread: ", e);
                                err = e;
                                seg.release();
                                p = pos <= -1L || err != null ? Long.MAX_VALUE : ((FileWriteAheadLogManager)FileWriteAheadLogManager.this).currentHandle().written;
                            }
                            catch (Throwable throwable) {
                                seg.release();
                                long p2 = pos <= -1L || err != null ? Long.MAX_VALUE : ((FileWriteAheadLogManager)FileWriteAheadLogManager.this).currentHandle().written;
                                this.unparkWaiters(p2);
                                throw throwable;
                            }
                            this.unparkWaiters(p);
                            continue;
                        }
                        this.unparkWaiters(p);
                        continue;
                    }
                }
                this.unparkWaiters(Long.MAX_VALUE);
            }
            catch (Throwable t) {
                err = t;
            }
            finally {
                if (err == null && !this.shutdown) {
                    err = new IllegalStateException("Thread " + this.getName() + " is terminated unexpectedly");
                }
                if (err instanceof OutOfMemoryError) {
                    FileWriteAheadLogManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, err));
                } else if (err != null) {
                    FileWriteAheadLogManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err));
                }
            }
        }

        public void shutdown() throws IgniteInterruptedCheckedException {
            this.shutdown = true;
            LockSupport.unpark(this);
            U.join(this);
        }

        private void unparkWaiters(long pos) {
            assert (pos > Long.MIN_VALUE) : pos;
            for (Map.Entry<Thread, Long> e : this.waiters.entrySet()) {
                Long val = e.getValue();
                if (val > pos) continue;
                if (val != Long.MIN_VALUE) {
                    this.waiters.put(e.getKey(), Long.MIN_VALUE);
                }
                LockSupport.unpark(e.getKey());
            }
        }

        void force() throws IgniteCheckedException {
            this.flushBuffer(-3L);
        }

        void close() throws IgniteCheckedException {
            this.flushBuffer(-2L);
        }

        void flushAll() throws IgniteCheckedException {
            this.flushBuffer(-1L);
        }

        void flushBuffer(long expPos) throws StorageException, IgniteCheckedException {
            if (FileWriteAheadLogManager.this.mmap) {
                return;
            }
            Throwable err = ((FileWriteAheadLogManager)FileWriteAheadLogManager.this).walWriter.err;
            if (err != null) {
                FileWriteAheadLogManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, err));
            }
            if (expPos == -1L) {
                expPos = FileWriteAheadLogManager.this.currentHandle().buf.tail();
            }
            Thread t = Thread.currentThread();
            this.waiters.put(t, expPos);
            LockSupport.unpark(FileWriteAheadLogManager.this.walWriter);
            while (true) {
                Long val = this.waiters.get(t);
                assert (val != null) : "Only this thread can remove thread from waiters";
                if (val == Long.MIN_VALUE) {
                    this.waiters.remove(t);
                    return;
                }
                LockSupport.park();
            }
        }

        private void writeBuffer(long pos, ByteBuffer buf) throws StorageException, IgniteCheckedException {
            FileWriteHandle hdl = FileWriteAheadLogManager.this.currentHandle();
            assert (hdl.fileIO != null) : "Writing to a closed segment.";
            FileWriteAheadLogManager.this.checkNode();
            long lastLogged = U.currentTimeMillis();
            long logBackoff = 2000L;
            while (hdl.written != pos) {
                assert (hdl.written < pos) : "written = " + hdl.written + ", pos = " + pos;
                long now = U.currentTimeMillis();
                if (now - lastLogged >= logBackoff) {
                    if (logBackoff < 3600000L) {
                        logBackoff *= 2L;
                    }
                    U.warn(FileWriteAheadLogManager.this.log, "Still waiting for a concurrent write to complete [written=" + hdl.written + ", pos=" + pos + ", lastFsyncPos=" + hdl.lastFsyncPos + ", stop=" + hdl.stop.get() + ", actualPos=" + hdl.safePosition() + ']');
                    lastLogged = now;
                }
                FileWriteAheadLogManager.this.checkNode();
            }
            int size = buf.remaining();
            assert (size > 0) : size;
            try {
                assert (hdl.written == hdl.fileIO.position());
                do {
                    hdl.fileIO.write(buf);
                } while (buf.hasRemaining());
                hdl.written += (long)size;
                FileWriteAheadLogManager.this.metrics.onWalBytesWritten(size);
                assert (hdl.written == hdl.fileIO.position());
            }
            catch (IOException e) {
                StorageException se = new StorageException("Unable to write", e);
                FileWriteAheadLogManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, se));
                throw se;
            }
        }
    }

    private static class RecordsIterator
    extends AbstractWalRecordsIterator {
        private static final long serialVersionUID = 0L;
        private final File walWorkDir;
        private final File walArchiveDir;
        @Nullable
        private final FileArchiver archiver;
        private final FileDecompressor decompressor;
        private final DataStorageConfiguration dsCfg;
        @Nullable
        private FileWALPointer start;
        @Nullable
        private FileWALPointer end;

        private RecordsIterator(GridCacheSharedContext cctx, File walWorkDir, File walArchiveDir, @Nullable FileWALPointer start, @Nullable FileWALPointer end, DataStorageConfiguration dsCfg, @NotNull RecordSerializerFactory serializerFactory, FileIOFactory ioFactory, @Nullable FileArchiver archiver, FileDecompressor decompressor, IgniteLogger log) throws IgniteCheckedException {
            super(log, cctx, serializerFactory, ioFactory, dsCfg.getWalRecordIteratorBufferSize());
            this.walWorkDir = walWorkDir;
            this.walArchiveDir = walArchiveDir;
            this.dsCfg = dsCfg;
            this.archiver = archiver;
            this.start = start;
            this.end = end;
            this.decompressor = decompressor;
            this.init();
            this.advance();
        }

        @Override
        protected ReadFileHandle initReadHandle(@NotNull AbstractWalRecordsIterator.AbstractFileDescriptor desc, @Nullable FileWALPointer start) throws IgniteCheckedException, FileNotFoundException {
            if (this.decompressor != null && !desc.file().exists()) {
                FileDescriptor zipFile = new FileDescriptor(new File(this.walArchiveDir, FileDescriptor.fileName(desc.idx()) + ".zip"));
                if (!zipFile.file.exists()) {
                    throw new FileNotFoundException("Both compressed and raw segment files are missing in archive [segmentIdx=" + desc.idx() + "]");
                }
                this.decompressor.decompressFile(desc.idx()).get();
            }
            return (ReadFileHandle)super.initReadHandle(desc, start);
        }

        @Override
        protected void onClose() throws IgniteCheckedException {
            super.onClose();
            this.curRec = null;
            AbstractWalRecordsIterator.AbstractReadFileHandle handle = this.closeCurrentWalSegment();
            if (handle != null && handle.workDir()) {
                this.releaseWorkSegment(this.curWalSegmIdx);
            }
            this.curWalSegmIdx = Integer.MAX_VALUE;
        }

        private void init() throws IgniteCheckedException {
            FileDescriptor[] descs = FileWriteAheadLogManager.loadFileDescriptors(this.walArchiveDir);
            if (this.start != null) {
                if (!F.isEmpty(descs)) {
                    if (descs[0].idx() > this.start.index()) {
                        throw new IgniteCheckedException("WAL history is too short [descs=" + Arrays.asList(descs) + ", start=" + this.start + ']');
                    }
                    for (FileDescriptor desc : descs) {
                        if (desc.idx() != this.start.index()) continue;
                        this.curWalSegmIdx = this.start.index();
                        break;
                    }
                    if (this.curWalSegmIdx == -1L) {
                        long lastArchived = descs[descs.length - 1].idx();
                        if (lastArchived > this.start.index()) {
                            throw new IgniteCheckedException("WAL history is corrupted (segment is missing): " + this.start);
                        }
                        this.curWalSegmIdx = this.start.index();
                    }
                } else {
                    this.curWalSegmIdx = this.start.index();
                }
            } else {
                this.curWalSegmIdx = !F.isEmpty(descs) ? descs[0].idx() : 0L;
            }
            --this.curWalSegmIdx;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Initialized WAL cursor [start=" + this.start + ", end=" + this.end + ", curWalSegmIdx=" + this.curWalSegmIdx + ']');
            }
        }

        @Override
        protected AbstractWalRecordsIterator.AbstractReadFileHandle advanceSegment(@Nullable AbstractWalRecordsIterator.AbstractReadFileHandle curWalSegment) throws IgniteCheckedException {
            ReadFileHandle nextHandle;
            FileDescriptor fd;
            if (curWalSegment != null) {
                curWalSegment.close();
                if (curWalSegment.workDir()) {
                    this.releaseWorkSegment(curWalSegment.idx());
                }
            }
            if (this.end != null && this.curWalSegmIdx + 1L > this.end.index()) {
                return null;
            }
            ++this.curWalSegmIdx;
            boolean readArchive = this.canReadArchiveOrReserveWork(this.curWalSegmIdx);
            if (this.archiver == null || readArchive) {
                fd = new FileDescriptor(new File(this.walArchiveDir, FileDescriptor.fileName(this.curWalSegmIdx)));
            } else {
                long workIdx = this.curWalSegmIdx % (long)this.dsCfg.getWalSegments();
                fd = new FileDescriptor(new File(this.walWorkDir, FileDescriptor.fileName(workIdx)), this.curWalSegmIdx);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Reading next file [absIdx=" + this.curWalSegmIdx + ", file=" + fd.file.getAbsolutePath() + ']');
            }
            try {
                nextHandle = this.initReadHandle(fd, this.start != null && this.curWalSegmIdx == this.start.index() ? this.start : null);
            }
            catch (FileNotFoundException e) {
                if (readArchive) {
                    throw new IgniteCheckedException("Missing WAL segment in the archive", e);
                }
                nextHandle = null;
            }
            if (nextHandle == null) {
                if (!readArchive) {
                    this.releaseWorkSegment(this.curWalSegmIdx);
                }
            } else {
                nextHandle.workDir = !readArchive;
            }
            this.curRec = null;
            return nextHandle;
        }

        private boolean canReadArchiveOrReserveWork(long absIdx) {
            return this.archiver != null && this.archiver.checkCanReadArchiveOrReserveWorkSegment(absIdx);
        }

        private void releaseWorkSegment(long absIdx) {
            if (this.archiver != null) {
                this.archiver.releaseWorkSegment(absIdx);
            }
        }

        @Override
        protected AbstractWalRecordsIterator.AbstractReadFileHandle createReadFileHandle(FileIO fileIO, long idx, RecordSerializer ser, FileInput in) {
            return new ReadFileHandle(fileIO, idx, ser, in);
        }
    }

    private class FileWriteHandle
    extends FileHandle {
        private final RecordSerializer serializer;
        private volatile boolean resume;
        volatile long written;
        private volatile long lastFsyncPos;
        private final AtomicBoolean stop;
        private final Lock lock;
        private final Condition fsync;
        private final Condition nextSegment;
        private final SegmentedRingByteBuffer buf;

        private FileWriteHandle(FileIO fileIO, long idx, long pos, boolean resume, RecordSerializer serializer, SegmentedRingByteBuffer buf) throws IOException {
            super(fileIO, idx);
            this.stop = new AtomicBoolean(false);
            this.lock = new ReentrantLock();
            this.fsync = this.lock.newCondition();
            this.nextSegment = this.lock.newCondition();
            assert (serializer != null);
            if (!FileWriteAheadLogManager.this.mmap) {
                fileIO.position(pos);
            }
            this.serializer = serializer;
            this.written = pos;
            this.lastFsyncPos = pos;
            this.resume = resume;
            this.buf = buf;
        }

        public void writeHeader() {
            SegmentedRingByteBuffer.WriteSegment seg = this.buf.offer(29);
            assert (seg != null && seg.position() > 0L);
            FileWriteAheadLogManager.prepareSerializerVersionBuffer(this.idx, FileWriteAheadLogManager.this.serializerVersion(), false, seg.buffer());
            seg.release();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private WALPointer addRecord(WALRecord rec) throws StorageException, IgniteCheckedException {
            assert (rec.size() > 0) : rec;
            while (true) {
                FileWriteAheadLogManager.this.checkNode();
                SegmentedRingByteBuffer.WriteSegment seg = rec.type() == WALRecord.RecordType.SWITCH_SEGMENT_RECORD && !((FileWriteAheadLogManager)FileWriteAheadLogManager.this).currHnd.resume ? this.buf.offerSafe(rec.size()) : this.buf.offer(rec.size());
                FileWALPointer ptr = null;
                if (seg != null) {
                    FileWALPointer fileWALPointer;
                    ByteBuffer buf;
                    int pos;
                    block11: {
                        pos = (int)(seg.position() - (long)rec.size());
                        buf = seg.buffer();
                        if (buf != null && (!this.stop.get() || rec.type() == WALRecord.RecordType.SWITCH_SEGMENT_RECORD)) break block11;
                        WALPointer wALPointer = null;
                        seg.release();
                        if (FileWriteAheadLogManager.this.mode == WALMode.BACKGROUND && rec instanceof CheckpointRecord) {
                            this.flushOrWait(ptr);
                        }
                        return wALPointer;
                    }
                    try {
                        ptr = new FileWALPointer(this.idx, pos, rec.size());
                        rec.position(ptr);
                        this.fillBuffer(buf, rec);
                        if (FileWriteAheadLogManager.this.mmap) {
                            long written0;
                            do {
                                written0 = this.written;
                            } while (seg.position() > written0 && !WRITTEN_UPD.compareAndSet(this, written0, seg.position()));
                        }
                        fileWALPointer = ptr;
                        seg.release();
                    }
                    catch (Throwable throwable) {
                        seg.release();
                        if (FileWriteAheadLogManager.this.mode == WALMode.BACKGROUND && rec instanceof CheckpointRecord) {
                            this.flushOrWait(ptr);
                        }
                        throw throwable;
                    }
                    if (FileWriteAheadLogManager.this.mode == WALMode.BACKGROUND && rec instanceof CheckpointRecord) {
                        this.flushOrWait(ptr);
                    }
                    return fileWALPointer;
                }
                FileWriteAheadLogManager.this.walWriter.flushAll();
            }
        }

        private void flushOrWait(FileWALPointer ptr) throws IgniteCheckedException {
            if (ptr != null && ptr.index() != this.idx) {
                return;
            }
            this.flush(ptr);
        }

        private void flush(FileWALPointer ptr) throws IgniteCheckedException, StorageException {
            if (ptr == null) {
                FileWriteAheadLogManager.this.walWriter.flushAll();
                return;
            }
            assert (ptr.index() == this.idx);
            FileWriteAheadLogManager.this.walWriter.flushBuffer(ptr.fileOffset());
        }

        private void fillBuffer(ByteBuffer buf, WALRecord rec) throws IgniteCheckedException {
            try {
                this.serializer.writeRecord(rec, buf);
            }
            catch (RuntimeException e) {
                throw new IllegalStateException("Failed to write record: " + rec, e);
            }
        }

        private boolean needFsync(FileWALPointer ptr) {
            return this.idx == ptr.index() && this.lastFsyncPos <= (long)ptr.fileOffset();
        }

        private FileWALPointer position() {
            this.lock.lock();
            try {
                FileWALPointer fileWALPointer = new FileWALPointer(this.idx, (int)this.written, 0);
                return fileWALPointer;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fsync(FileWALPointer ptr) throws StorageException, IgniteCheckedException {
            this.lock.lock();
            try {
                if (ptr != null) {
                    if (!this.needFsync(ptr)) {
                        return;
                    }
                    if (FileWriteAheadLogManager.this.fsyncDelay > 0L && !this.stop.get()) {
                        U.await(this.fsync, FileWriteAheadLogManager.this.fsyncDelay, TimeUnit.NANOSECONDS);
                        if (!this.needFsync(ptr)) {
                            return;
                        }
                    }
                }
                this.flushOrWait(ptr);
                if (this.stop.get()) {
                    return;
                }
                long lastFsyncPos0 = this.lastFsyncPos;
                long written0 = this.written;
                if (lastFsyncPos0 != written0) {
                    long end;
                    long start;
                    assert (lastFsyncPos0 < written0) : "lastFsyncPos=" + lastFsyncPos0 + ", written=" + written0;
                    boolean metricsEnabled = FileWriteAheadLogManager.this.metrics.metricsEnabled();
                    long l = start = metricsEnabled ? System.nanoTime() : 0L;
                    if (FileWriteAheadLogManager.this.mmap) {
                        long pos = ptr == null ? -1L : (long)ptr.fileOffset();
                        List<SegmentedRingByteBuffer.ReadSegment> segs = this.buf.poll(pos);
                        if (segs != null) {
                            assert (segs.size() == 1);
                            SegmentedRingByteBuffer.ReadSegment seg = segs.get(0);
                            int off = seg.buffer().position();
                            int len = seg.buffer().limit() - off;
                            this.fsync((MappedByteBuffer)this.buf.buf, off, len);
                            seg.release();
                        }
                    } else {
                        FileWriteAheadLogManager.this.walWriter.force();
                    }
                    this.lastFsyncPos = this.written;
                    if (FileWriteAheadLogManager.this.fsyncDelay > 0L) {
                        this.fsync.signalAll();
                    }
                    long l2 = end = metricsEnabled ? System.nanoTime() : 0L;
                    if (metricsEnabled) {
                        FileWriteAheadLogManager.this.metrics.onFsync(end - start);
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        private void fsync(MappedByteBuffer buf, int off, int len) throws IgniteCheckedException {
            try {
                long mappedOff = (Long)mappingOffset.invoke((Object)buf, new Object[0]);
                assert (mappedOff == 0L) : mappedOff;
                long addr = (Long)mappingAddress.invoke((Object)buf, mappedOff);
                long delta = (addr + (long)off) % (long)PAGE_SIZE;
                long alignedAddr = addr + (long)off - delta;
                force0.invoke((Object)buf, fd.get(buf), alignedAddr, (long)len + delta);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IgniteCheckedException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean close(boolean rollOver) throws IgniteCheckedException, StorageException {
            if (this.stop.compareAndSet(false, true)) {
                this.lock.lock();
                try {
                    this.flushOrWait(null);
                    try {
                        List<SegmentedRingByteBuffer.ReadSegment> segs;
                        RecordSerializer backwardSerializer = new RecordSerializerFactoryImpl(FileWriteAheadLogManager.this.cctx).createSerializer(FileWriteAheadLogManager.this.serializerVer);
                        SwitchSegmentRecord segmentRecord = new SwitchSegmentRecord();
                        int switchSegmentRecSize = backwardSerializer.size(segmentRecord);
                        if (rollOver && this.written < FileWriteAheadLogManager.this.maxWalSegmentSize - (long)switchSegmentRecSize) {
                            segmentRecord.size(switchSegmentRecSize);
                            WALPointer segRecPtr = this.addRecord(segmentRecord);
                            if (segRecPtr != null) {
                                this.fsync((FileWALPointer)segRecPtr);
                            }
                        }
                        if (FileWriteAheadLogManager.this.mmap && (segs = this.buf.poll(FileWriteAheadLogManager.this.maxWalSegmentSize)) != null) {
                            assert (segs.size() == 1);
                            segs.get(0).release();
                        }
                        if (FileWriteAheadLogManager.this.mode != WALMode.NONE) {
                            if (FileWriteAheadLogManager.this.mmap) {
                                ((MappedByteBuffer)this.buf.buf).force();
                            } else {
                                this.fileIO.force();
                            }
                            this.lastFsyncPos = this.written;
                        }
                        if (FileWriteAheadLogManager.this.mmap) {
                            try {
                                this.fileIO.close();
                            }
                            catch (IOException iOException) {}
                        } else {
                            FileWriteAheadLogManager.this.walWriter.close();
                            if (!rollOver) {
                                this.buf.free();
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new IgniteCheckedException(e);
                    }
                    if (FileWriteAheadLogManager.this.log.isDebugEnabled()) {
                        FileWriteAheadLogManager.this.log.debug("Closed WAL write handle [idx=" + this.idx + "]");
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (FileWriteAheadLogManager.this.mmap) {
                        this.buf.free();
                    }
                    this.lock.unlock();
                }
            }
            return false;
        }

        private void signalNextAvailable() {
            this.lock.lock();
            try {
                assert (FileWriteAheadLogManager.this.cctx.kernalContext().invalid() || this.written == this.lastFsyncPos || FileWriteAheadLogManager.this.mode != WALMode.FSYNC) : "fsync [written=" + this.written + ", lastFsync=" + this.lastFsyncPos + ", idx=" + this.idx + ']';
                this.fileIO = null;
                this.nextSegment.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        private void awaitNext() {
            this.lock.lock();
            try {
                while (this.fileIO != null) {
                    U.awaitQuiet(this.nextSegment);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        private String safePosition() {
            FileIO io = this.fileIO;
            if (io == null) {
                return "null";
            }
            try {
                return String.valueOf(io.position());
            }
            catch (IOException e) {
                return "{Failed to read channel position: " + e.getMessage() + '}';
            }
        }
    }

    public static class ReadFileHandle
    extends FileHandle
    implements AbstractWalRecordsIterator.AbstractReadFileHandle {
        RecordSerializer ser;
        FileInput in;
        private boolean workDir;

        public ReadFileHandle(FileIO fileIO, long idx, RecordSerializer ser, FileInput in) {
            super(fileIO, idx);
            this.ser = ser;
            this.in = in;
        }

        @Override
        public void close() throws IgniteCheckedException {
            try {
                this.fileIO.close();
            }
            catch (IOException e) {
                throw new IgniteCheckedException(e);
            }
        }

        @Override
        public long idx() {
            return this.idx;
        }

        @Override
        public FileInput in() {
            return this.in;
        }

        @Override
        public RecordSerializer ser() {
            return this.ser;
        }

        @Override
        public boolean workDir() {
            return this.workDir;
        }
    }

    private static abstract class FileHandle {
        FileIO fileIO;
        protected final long idx;

        private FileHandle(FileIO fileIO, long idx) {
            this.fileIO = fileIO;
            this.idx = idx;
        }
    }

    public static class FileDescriptor
    implements Comparable<FileDescriptor>,
    AbstractWalRecordsIterator.AbstractFileDescriptor {
        protected final File file;
        protected final long idx;

        public FileDescriptor(@NotNull File file) {
            this(file, null);
        }

        public FileDescriptor(@NotNull File file, @Nullable Long idx) {
            this.file = file;
            String fileName = file.getName();
            assert (fileName.contains(FileWriteAheadLogManager.WAL_SEGMENT_FILE_EXT));
            this.idx = idx == null ? Long.parseLong(fileName.substring(0, 16)) : idx;
        }

        public static String fileName(long segment) {
            SB b = new SB();
            String segmentStr = Long.toString(segment);
            for (int i = segmentStr.length(); i < 16; ++i) {
                b.a('0');
            }
            b.a(segmentStr).a(FileWriteAheadLogManager.WAL_SEGMENT_FILE_EXT);
            return b.toString();
        }

        @Override
        public int compareTo(@NotNull FileDescriptor o) {
            return Long.compare(this.idx, o.idx);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileDescriptor)) {
                return false;
            }
            FileDescriptor that = (FileDescriptor)o;
            return this.idx == that.idx;
        }

        public int hashCode() {
            return (int)(this.idx ^ this.idx >>> 32);
        }

        public long getIdx() {
            return this.idx;
        }

        public String getAbsolutePath() {
            return this.file.getAbsolutePath();
        }

        @Override
        public boolean isCompressed() {
            return this.file.getName().endsWith(".zip");
        }

        @Override
        public File file() {
            return this.file;
        }

        @Override
        public long idx() {
            return this.idx;
        }
    }

    private class FileDecompressor
    extends Thread {
        private volatile boolean stopped;
        private Map<Long, GridFutureAdapter<Void>> decompressionFutures;
        private final PriorityBlockingQueue<Long> segmentsQueue;
        private byte[] arr;

        FileDecompressor() {
            super("wal-file-decompressor%" + FileWriteAheadLogManager.this.cctx.igniteInstanceName());
            this.decompressionFutures = new HashMap<Long, GridFutureAdapter<Void>>();
            this.segmentsQueue = new PriorityBlockingQueue();
            this.arr = new byte[0x100000];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted() && !this.stopped) {
                long segmentToDecompress = -1L;
                try {
                    block38: {
                        segmentToDecompress = this.segmentsQueue.take();
                        if (this.stopped) break;
                        File zip = new File(FileWriteAheadLogManager.this.walArchiveDir, FileDescriptor.fileName(segmentToDecompress) + ".zip");
                        File unzipTmp = new File(FileWriteAheadLogManager.this.walArchiveDir, FileDescriptor.fileName(segmentToDecompress) + ".tmp");
                        File unzip = new File(FileWriteAheadLogManager.this.walArchiveDir, FileDescriptor.fileName(segmentToDecompress));
                        try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(zip)));
                             FileIO io = FileWriteAheadLogManager.this.ioFactory.create(unzipTmp);){
                            int bytesRead;
                            zis.getNextEntry();
                            while ((bytesRead = zis.read(this.arr)) > 0) {
                                io.write(this.arr, 0, bytesRead);
                            }
                        }
                        try {
                            Files.move(unzipTmp.toPath(), unzip.toPath(), new CopyOption[0]);
                        }
                        catch (FileAlreadyExistsException e) {
                            U.error(FileWriteAheadLogManager.this.log, "Can't rename temporary unzipped segment: raw segment is already present [tmp=" + unzipTmp + ", raw=" + unzip + "]", e);
                            if (unzipTmp.delete()) break block38;
                            U.error(FileWriteAheadLogManager.this.log, "Can't delete temporary unzipped segment [tmp=" + unzipTmp + "]");
                        }
                    }
                    FileDecompressor fileDecompressor = this;
                    synchronized (fileDecompressor) {
                        this.decompressionFutures.remove(segmentToDecompress).onDone();
                    }
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable t) {
                    if (this.stopped || segmentToDecompress == -1L) continue;
                    IgniteCheckedException e = new IgniteCheckedException("Error during WAL segment decompression [segmentIdx=" + segmentToDecompress + "]", t);
                    FileDecompressor fileDecompressor = this;
                    synchronized (fileDecompressor) {
                        this.decompressionFutures.remove(segmentToDecompress).onDone(e);
                    }
                }
            }
        }

        synchronized IgniteInternalFuture<Void> decompressFile(long idx) {
            if (this.decompressionFutures.containsKey(idx)) {
                return this.decompressionFutures.get(idx);
            }
            File f = new File(FileWriteAheadLogManager.this.walArchiveDir, FileDescriptor.fileName(idx));
            if (f.exists()) {
                return new GridFinishedFuture<Void>();
            }
            this.segmentsQueue.put(idx);
            GridFutureAdapter<Void> res = new GridFutureAdapter<Void>();
            this.decompressionFutures.put(idx, res);
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdown() throws IgniteInterruptedCheckedException {
            FileDecompressor fileDecompressor = this;
            synchronized (fileDecompressor) {
                this.stopped = true;
                this.segmentsQueue.put(-1L);
            }
            U.join(this);
        }
    }

    private class FileCompressor
    extends Thread {
        private volatile boolean stopped;
        private volatile long lastCompressedIdx;
        private volatile long lastAllowedToCompressIdx;

        FileCompressor() {
            super("wal-file-compressor%" + FileWriteAheadLogManager.this.cctx.igniteInstanceName());
            this.lastCompressedIdx = -1L;
            this.lastAllowedToCompressIdx = -1L;
        }

        private void init() {
            File[] toDel;
            for (File f : toDel = FileWriteAheadLogManager.this.walArchiveDir.listFiles(WAL_SEGMENT_TEMP_FILE_COMPACTED_FILTER)) {
                if (this.stopped) {
                    return;
                }
                f.delete();
            }
            FileDescriptor[] alreadyCompressed = FileWriteAheadLogManager.scan(FileWriteAheadLogManager.this.walArchiveDir.listFiles(WAL_SEGMENT_FILE_COMPACTED_FILTER));
            if (alreadyCompressed.length > 0) {
                this.lastCompressedIdx = alreadyCompressed[alreadyCompressed.length - 1].getIdx();
            }
        }

        synchronized void allowCompressionUntil(long lastCpStartIdx) {
            this.lastAllowedToCompressIdx = lastCpStartIdx - 1L;
            this.notify();
        }

        synchronized void onNextSegmentArchived() {
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long tryReserveNextSegmentOrWait() throws InterruptedException, IgniteCheckedException {
            long segmentToCompress = this.lastCompressedIdx + 1L;
            FileCompressor fileCompressor = this;
            synchronized (fileCompressor) {
                if (this.stopped) {
                    return -1L;
                }
                while (segmentToCompress > Math.min(this.lastAllowedToCompressIdx, FileWriteAheadLogManager.this.archivedMonitor.lastArchivedAbsoluteIndex())) {
                    this.wait();
                    if (!this.stopped) continue;
                    return -1L;
                }
            }
            segmentToCompress = Math.max(segmentToCompress, FileWriteAheadLogManager.this.lastTruncatedArchiveIdx + 1L);
            boolean reserved = FileWriteAheadLogManager.this.reserve(new FileWALPointer(segmentToCompress, 0, 0));
            return reserved ? segmentToCompress : -1L;
        }

        private void deleteObsoleteRawSegments() {
            FileDescriptor[] descs = FileWriteAheadLogManager.scan(FileWriteAheadLogManager.this.walArchiveDir.listFiles(WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER));
            HashSet<Long> indices = new HashSet<Long>();
            HashSet<Long> duplicateIndices = new HashSet<Long>();
            for (FileDescriptor desc : descs) {
                if (indices.add(desc.idx)) continue;
                duplicateIndices.add(desc.idx);
            }
            for (FileDescriptor desc : descs) {
                if (desc.isCompressed()) continue;
                if (FileWriteAheadLogManager.this.segmentReservedOrLocked(desc.idx)) {
                    return;
                }
                if (desc.idx >= this.lastCompressedIdx || !duplicateIndices.contains(desc.idx) || desc.file.delete()) continue;
                U.warn(FileWriteAheadLogManager.this.log, "Failed to remove obsolete WAL segment (make sure the process has enough rights): " + desc.file.getAbsolutePath() + ", exists: " + desc.file.exists());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.init();
            while (!Thread.currentThread().isInterrupted() && !this.stopped) {
                long currReservedSegment = -1L;
                try {
                    this.deleteObsoleteRawSegments();
                    currReservedSegment = this.tryReserveNextSegmentOrWait();
                    if (currReservedSegment == -1L) continue;
                    File tmpZip = new File(FileWriteAheadLogManager.this.walArchiveDir, FileDescriptor.fileName(currReservedSegment) + ".zip" + ".tmp");
                    File zip = new File(FileWriteAheadLogManager.this.walArchiveDir, FileDescriptor.fileName(currReservedSegment) + ".zip");
                    File raw = new File(FileWriteAheadLogManager.this.walArchiveDir, FileDescriptor.fileName(currReservedSegment));
                    if (!Files.exists(raw.toPath(), new LinkOption[0])) {
                        throw new IgniteCheckedException("WAL archive segment is missing: " + raw);
                    }
                    this.compressSegmentToFile(currReservedSegment, raw, tmpZip);
                    Files.move(tmpZip.toPath(), zip.toPath(), new CopyOption[0]);
                    if (FileWriteAheadLogManager.this.mode != WALMode.NONE) {
                        try (FileIO f0 = FileWriteAheadLogManager.this.ioFactory.create(zip, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);){
                            f0.force();
                        }
                    }
                    this.lastCompressedIdx = currReservedSegment;
                }
                catch (IOException | IgniteCheckedException e) {
                    U.error(FileWriteAheadLogManager.this.log, "Compression of WAL segment [idx=" + currReservedSegment + "] was skipped due to unexpected error", e);
                    ++this.lastCompressedIdx;
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    try {
                        if (currReservedSegment == -1L) continue;
                        FileWriteAheadLogManager.this.release(new FileWALPointer(currReservedSegment, 0, 0));
                    }
                    catch (IgniteCheckedException e) {
                        U.error(FileWriteAheadLogManager.this.log, "Can't release raw WAL segment [idx=" + currReservedSegment + "] after compression", e);
                    }
                }
            }
        }

        private void compressSegmentToFile(long nextSegment, File raw, File zip) throws IOException, IgniteCheckedException {
            int segmentSerializerVer;
            try (FileIO fileIO = FileWriteAheadLogManager.this.ioFactory.create(raw);){
                segmentSerializerVer = RecordV1Serializer.readSegmentHeader(fileIO, nextSegment).getSerializerVersion();
            }
            var7_5 = null;
            try (final ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zip)));){
                zos.putNextEntry(new ZipEntry(""));
                ByteBuffer buf = ByteBuffer.allocate(29);
                buf.order(ByteOrder.nativeOrder());
                zos.write(FileWriteAheadLogManager.prepareSerializerVersionBuffer(nextSegment, segmentSerializerVer, true, buf).array());
                CIX1<WALRecord> appendToZipC = new CIX1<WALRecord>(){

                    @Override
                    public void applyx(WALRecord record) throws IgniteCheckedException {
                        MarshalledRecord marshRec = (MarshalledRecord)record;
                        try {
                            zos.write(marshRec.buffer().array(), 0, marshRec.buffer().remaining());
                        }
                        catch (IOException e) {
                            throw new IgniteCheckedException(e);
                        }
                    }
                };
                try (SingleSegmentLogicalRecordsIterator iter = new SingleSegmentLogicalRecordsIterator(FileWriteAheadLogManager.this.log, FileWriteAheadLogManager.this.cctx, FileWriteAheadLogManager.this.ioFactory, 0x100000, nextSegment, FileWriteAheadLogManager.this.walArchiveDir, appendToZipC);){
                    while (iter.hasNextX()) {
                        iter.nextX();
                    }
                }
                RecordSerializer ser = new RecordSerializerFactoryImpl(FileWriteAheadLogManager.this.cctx).createSerializer(segmentSerializerVer);
                ByteBuffer heapBuf = this.prepareSwitchSegmentRecordBuffer(nextSegment, ser);
                zos.write(heapBuf.array());
            }
            catch (Throwable throwable) {
                var7_5 = throwable;
                throw throwable;
            }
        }

        @NotNull
        private ByteBuffer prepareSwitchSegmentRecordBuffer(long nextSegment, RecordSerializer ser) throws IgniteCheckedException {
            SwitchSegmentRecord switchRecord = new SwitchSegmentRecord();
            int switchRecordSize = ser.size(switchRecord);
            switchRecord.size(switchRecordSize);
            switchRecord.position(new FileWALPointer(nextSegment, 0, switchRecordSize));
            ByteBuffer heapBuf = ByteBuffer.allocate(switchRecordSize);
            ser.writeRecord(switchRecord, heapBuf);
            return heapBuf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdown() throws IgniteInterruptedCheckedException {
            FileCompressor fileCompressor = this;
            synchronized (fileCompressor) {
                this.stopped = true;
                this.notifyAll();
            }
            U.join(this);
        }
    }

    private class FileArchiver
    extends Thread {
        private IgniteCheckedException cleanErr;
        private long curAbsWalIdx;
        private volatile long lastAbsArchivedIdx;
        private volatile boolean stopped;
        private int formatted;
        private Map<Long, Integer> locked;

        private FileArchiver(long lastAbsArchivedIdx) {
            super("wal-file-archiver%" + FileWriteAheadLogManager.this.cctx.igniteInstanceName());
            this.curAbsWalIdx = -1L;
            this.lastAbsArchivedIdx = -1L;
            this.locked = new HashMap<Long, Integer>();
            this.lastAbsArchivedIdx = lastAbsArchivedIdx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdown() throws IgniteInterruptedCheckedException {
            FileArchiver fileArchiver = this;
            synchronized (fileArchiver) {
                this.stopped = true;
                this.notifyAll();
            }
            U.join(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void currentWalIndex(long curAbsWalIdx) {
            FileArchiver fileArchiver = this;
            synchronized (fileArchiver) {
                this.curAbsWalIdx = curAbsWalIdx;
                this.notifyAll();
            }
        }

        private synchronized boolean locked(long absIdx) {
            return this.locked.containsKey(absIdx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                this.allocateRemainingFiles();
            }
            catch (IgniteCheckedException e) {
                FileArchiver fileArchiver = this;
                // MONITORENTER : fileArchiver
                this.cleanErr = e;
                this.notifyAll();
                // MONITOREXIT : fileArchiver
                return;
            }
            Throwable err = null;
            try {
                FileArchiver fileArchiver = this;
                // MONITORENTER : fileArchiver
                while (this.curAbsWalIdx == -1L && !this.stopped) {
                    this.wait();
                }
                // MONITOREXIT : fileArchiver
                while (!Thread.currentThread().isInterrupted()) {
                    FileArchiver fileArchiver2;
                    if (this.stopped) return;
                    FileArchiver fileArchiver3 = this;
                    // MONITORENTER : fileArchiver3
                    assert (this.lastAbsArchivedIdx <= this.curAbsWalIdx) : "lastArchived=" + this.lastAbsArchivedIdx + ", current=" + this.curAbsWalIdx;
                    while (this.lastAbsArchivedIdx >= this.curAbsWalIdx - 1L && !this.stopped) {
                        this.wait();
                    }
                    long toArchive = this.lastAbsArchivedIdx + 1L;
                    // MONITOREXIT : fileArchiver3
                    if (this.stopped) {
                        return;
                    }
                    try {
                        SegmentArchiveResult res = this.archiveSegment(toArchive);
                        fileArchiver2 = this;
                        // MONITORENTER : fileArchiver2
                        while (this.locked.containsKey(toArchive) && !this.stopped) {
                            this.wait();
                        }
                        this.changeLastArchivedIndexAndNotifyWaiters(toArchive);
                        this.notifyAll();
                        // MONITOREXIT : fileArchiver2
                        if (!FileWriteAheadLogManager.this.evt.isRecordable(128)) continue;
                        FileWriteAheadLogManager.this.evt.record(new WalSegmentArchivedEvent(FileWriteAheadLogManager.this.cctx.discovery().localNode(), res.getAbsIdx(), res.getDstArchiveFile()));
                    }
                    catch (IgniteCheckedException e) {
                        fileArchiver2 = this;
                        // MONITORENTER : fileArchiver2
                        this.cleanErr = e;
                        this.notifyAll();
                        // MONITOREXIT : fileArchiver2
                    }
                }
                return;
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (Throwable t) {
                err = t;
                return;
            }
            finally {
                if (err == null && !this.stopped) {
                    err = new IllegalStateException("Thread " + this.getName() + " is terminated unexpectedly");
                }
                if (err instanceof OutOfMemoryError) {
                    FileWriteAheadLogManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, err));
                } else if (err != null) {
                    FileWriteAheadLogManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err));
                }
            }
        }

        private void changeLastArchivedIndexAndNotifyWaiters(long idx) {
            this.lastAbsArchivedIdx = idx;
            if (FileWriteAheadLogManager.this.compressor != null) {
                FileWriteAheadLogManager.this.compressor.onNextSegmentArchived();
            }
            FileWriteAheadLogManager.this.archivedMonitor.setLastArchivedAbsoluteIndex(idx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long nextAbsoluteSegmentIndex(long curIdx) throws IgniteCheckedException {
            FileArchiver fileArchiver = this;
            synchronized (fileArchiver) {
                if (this.cleanErr != null) {
                    throw this.cleanErr;
                }
                assert (curIdx == this.curAbsWalIdx);
                ++this.curAbsWalIdx;
                this.notifyAll();
                while (this.curAbsWalIdx - this.lastAbsArchivedIdx > (long)FileWriteAheadLogManager.this.dsCfg.getWalSegments() && this.cleanErr == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ignore) {
                        FileWriteAheadLogManager.this.interrupted.set(true);
                    }
                }
                while (this.curAbsWalIdx % (long)FileWriteAheadLogManager.this.dsCfg.getWalSegments() > (long)this.formatted) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ignore) {
                        FileWriteAheadLogManager.this.interrupted.set(true);
                    }
                }
                return this.curAbsWalIdx;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkCanReadArchiveOrReserveWorkSegment(long absIdx) {
            FileArchiver fileArchiver = this;
            synchronized (fileArchiver) {
                if (this.lastAbsArchivedIdx >= absIdx) {
                    if (FileWriteAheadLogManager.this.log.isDebugEnabled()) {
                        FileWriteAheadLogManager.this.log.debug("Not needed to reserve WAL segment: absIdx=" + absIdx + ";" + " lastAbsArchivedIdx=" + this.lastAbsArchivedIdx);
                    }
                    return true;
                }
                Integer cur = this.locked.get(absIdx);
                cur = cur == null ? 1 : cur + 1;
                this.locked.put(absIdx, cur);
                if (FileWriteAheadLogManager.this.log.isDebugEnabled()) {
                    FileWriteAheadLogManager.this.log.debug("Reserved work segment [absIdx=" + absIdx + ", pins=" + cur + ']');
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releaseWorkSegment(long absIdx) {
            FileArchiver fileArchiver = this;
            synchronized (fileArchiver) {
                Integer cur = this.locked.get(absIdx);
                assert (cur != null && cur > 0) : "WAL Segment with Index " + absIdx + " is not locked;" + " lastAbsArchivedIdx = " + this.lastAbsArchivedIdx;
                if (cur == 1) {
                    this.locked.remove(absIdx);
                    if (FileWriteAheadLogManager.this.log.isDebugEnabled()) {
                        FileWriteAheadLogManager.this.log.debug("Fully released work segment (ready to archive) [absIdx=" + absIdx + ']');
                    }
                } else {
                    this.locked.put(absIdx, cur - 1);
                    if (FileWriteAheadLogManager.this.log.isDebugEnabled()) {
                        FileWriteAheadLogManager.this.log.debug("Partially released work segment [absIdx=" + absIdx + ", pins=" + (cur - 1) + ']');
                    }
                }
                this.notifyAll();
            }
        }

        private SegmentArchiveResult archiveSegment(long absIdx) throws IgniteCheckedException {
            File dstFile;
            File origFile;
            block16: {
                long segIdx = absIdx % (long)FileWriteAheadLogManager.this.dsCfg.getWalSegments();
                origFile = new File(FileWriteAheadLogManager.this.walWorkDir, FileDescriptor.fileName(segIdx));
                String name = FileDescriptor.fileName(absIdx);
                File dstTmpFile = new File(FileWriteAheadLogManager.this.walArchiveDir, name + ".tmp");
                dstFile = new File(FileWriteAheadLogManager.this.walArchiveDir, name);
                if (FileWriteAheadLogManager.this.log.isDebugEnabled()) {
                    FileWriteAheadLogManager.this.log.debug("Starting to copy WAL segment [absIdx=" + absIdx + ", segIdx=" + segIdx + ", origFile=" + origFile.getAbsolutePath() + ", dstFile=" + dstFile.getAbsolutePath() + ']');
                }
                try {
                    Files.deleteIfExists(dstTmpFile.toPath());
                    Files.copy(origFile.toPath(), dstTmpFile.toPath(), new CopyOption[0]);
                    Files.move(dstTmpFile.toPath(), dstFile.toPath(), new CopyOption[0]);
                    if (FileWriteAheadLogManager.this.mode == WALMode.NONE) break block16;
                    try (FileIO f0 = FileWriteAheadLogManager.this.ioFactory.create(dstFile, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);){
                        f0.force();
                    }
                }
                catch (IOException e) {
                    throw new IgniteCheckedException("Failed to archive WAL segment [srcFile=" + origFile.getAbsolutePath() + ", dstFile=" + dstTmpFile.getAbsolutePath() + ']', e);
                }
            }
            if (FileWriteAheadLogManager.this.log.isDebugEnabled()) {
                FileWriteAheadLogManager.this.log.debug("Copied file [src=" + origFile.getAbsolutePath() + ", dst=" + dstFile.getAbsolutePath() + ']');
            }
            return new SegmentArchiveResult(absIdx, origFile, dstFile);
        }

        private boolean checkStop() {
            return this.stopped;
        }

        private void allocateRemainingFiles() throws IgniteCheckedException {
            FileWriteAheadLogManager.this.checkFiles(1, true, new IgnitePredicate<Integer>(){

                @Override
                public boolean apply(Integer integer) {
                    return !FileArchiver.this.checkStop();
                }
            }, new CI1<Integer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void apply(Integer idx) {
                    FileArchiver fileArchiver = FileArchiver.this;
                    synchronized (fileArchiver) {
                        FileArchiver.this.formatted = idx;
                        FileArchiver.this.notifyAll();
                    }
                }
            });
        }
    }
}

