/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.serializer;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.FilteredRecord;
import org.apache.ignite.internal.pagemem.wal.record.MarshalledRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.CacheVersionIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.ByteBufferBackedDataInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.ByteBufferExpander;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.SegmentEofException;
import org.apache.ignite.internal.processors.cache.persistence.wal.WalSegmentTailReachedException;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.PureJavaCrc32;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordDataV1Serializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.SegmentHeader;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.io.RecordIO;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;

public class RecordV1Serializer
implements RecordSerializer {
    public static final int REC_TYPE_SIZE = 1;
    public static final int FILE_WAL_POINTER_SIZE = 12;
    public static final int CRC_SIZE = 4;
    public static final int HEADER_RECORD_SIZE = 29;
    public static boolean skipCrc = IgniteSystemProperties.getBoolean("IGNITE_PDS_SKIP_CRC", false);
    private final RecordDataV1Serializer dataSerializer;
    private final boolean writePointer;
    private final IgniteBiPredicate<WALRecord.RecordType, WALPointer> recordFilter;
    private final boolean skipPositionCheck;
    private final boolean marshalledMode;
    private final ThreadLocal<ByteBuffer> heapTlb = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            ByteBuffer buf = ByteBuffer.allocate(4096);
            buf.order(GridUnsafe.NATIVE_BYTE_ORDER);
            return buf;
        }
    };
    private final RecordIO recordIO = new RecordIO(){

        @Override
        public int sizeWithHeaders(WALRecord record) throws IgniteCheckedException {
            int recordSize = RecordV1Serializer.this.dataSerializer.size(record);
            int recordSizeWithType = recordSize + 1;
            return record.type() != WALRecord.RecordType.SWITCH_SEGMENT_RECORD ? recordSizeWithType + 12 + 4 : recordSizeWithType;
        }

        @Override
        public WALRecord readWithHeaders(ByteBufferBackedDataInput in, WALPointer expPtr) throws IOException, IgniteCheckedException {
            WALRecord.RecordType recType = RecordV1Serializer.readRecordType(in);
            if (recType == WALRecord.RecordType.SWITCH_SEGMENT_RECORD) {
                throw new SegmentEofException("Reached end of segment", null);
            }
            FileWALPointer ptr = RecordV1Serializer.readPosition(in);
            if (!RecordV1Serializer.this.skipPositionCheck && !F.eq(ptr, expPtr)) {
                throw new SegmentEofException("WAL segment rollover detected (will end iteration) [expPtr=" + expPtr + ", readPtr=" + ptr + ']', null);
            }
            WALRecord rec = RecordV1Serializer.this.dataSerializer.readRecord(recType, in);
            rec.position(ptr);
            if (RecordV1Serializer.this.recordFilter != null && !RecordV1Serializer.this.recordFilter.apply(rec.type(), ptr)) {
                return FilteredRecord.INSTANCE;
            }
            if (RecordV1Serializer.this.marshalledMode) {
                ByteBuffer buf = (ByteBuffer)RecordV1Serializer.this.heapTlb.get();
                int recordSize = RecordV1Serializer.this.size(rec);
                if (buf.capacity() < recordSize) {
                    buf = ByteBuffer.allocate(recordSize * 3 / 2).order(ByteOrder.nativeOrder());
                    RecordV1Serializer.this.heapTlb.set(buf);
                } else {
                    buf.clear();
                }
                RecordV1Serializer.this.writeRecord(rec, buf);
                buf.flip();
                assert (buf.remaining() == recordSize);
                return new MarshalledRecord(rec.type(), rec.position(), buf);
            }
            return rec;
        }

        @Override
        public void writeWithHeaders(WALRecord rec, ByteBuffer buf) throws IgniteCheckedException {
            RecordV1Serializer.putRecordType(buf, rec);
            if (rec.type() == WALRecord.RecordType.SWITCH_SEGMENT_RECORD) {
                return;
            }
            RecordV1Serializer.putPositionOfRecord(buf, rec);
            RecordV1Serializer.this.dataSerializer.writeRecord(rec, buf);
        }
    };

    public RecordV1Serializer(RecordDataV1Serializer dataSerializer, boolean writePointer, boolean marshalledMode, boolean skipPositionCheck, IgniteBiPredicate<WALRecord.RecordType, WALPointer> recordFilter) {
        this.dataSerializer = dataSerializer;
        this.writePointer = writePointer;
        this.recordFilter = recordFilter;
        this.skipPositionCheck = skipPositionCheck;
        this.marshalledMode = marshalledMode;
    }

    @Override
    public int version() {
        return 1;
    }

    @Override
    public boolean writePointer() {
        return this.writePointer;
    }

    @Override
    public void writeRecord(WALRecord rec, ByteBuffer buf) throws IgniteCheckedException {
        RecordV1Serializer.writeWithCrc(rec, buf, this.recordIO);
    }

    @Override
    public WALRecord readRecord(FileInput in0, WALPointer expPtr) throws IOException, IgniteCheckedException {
        return RecordV1Serializer.readWithCrc(in0, expPtr, this.recordIO);
    }

    @Override
    public int size(WALRecord record) throws IgniteCheckedException {
        return this.recordIO.sizeWithHeaders(record);
    }

    public static void putPosition(ByteBuffer buf, FileWALPointer ptr) {
        buf.putLong(ptr.index());
        buf.putInt(ptr.fileOffset());
    }

    public static SegmentHeader readSegmentHeader(FileIO io, long expectedIdx) throws IgniteCheckedException, IOException {
        try (ByteBufferExpander buf = new ByteBufferExpander(29, ByteOrder.nativeOrder());){
            boolean compacted;
            FileInput in = new FileInput(io, buf);
            in.ensure(29);
            int recordType = in.readUnsignedByte();
            if (recordType == 0) {
                throw new SegmentEofException("Reached logical end of the segment", null);
            }
            WALRecord.RecordType type = WALRecord.RecordType.fromOrdinal(recordType - 1);
            if (type != WALRecord.RecordType.HEADER_RECORD) {
                throw new IOException("Can't read serializer version", null);
            }
            FileWALPointer ptr = RecordV1Serializer.readPosition(in);
            if (expectedIdx != ptr.index()) {
                throw new SegmentEofException("Reached logical end of the segment by pointer", null);
            }
            assert (ptr.fileOffset() == 0) : "Header record should be placed at the beginning of file " + ptr;
            long hdrMagicNum = in.readLong();
            if (hdrMagicNum == -5705984118950656934L) {
                compacted = false;
            } else if (hdrMagicNum == 5622654036411574606L) {
                compacted = true;
            } else {
                throw new IOException("Magic is corrupted [exp=" + U.hexLong(-5705984118950656934L) + ", actual=" + U.hexLong(hdrMagicNum) + ']');
            }
            int ver = in.readInt();
            in.readInt();
            SegmentHeader segmentHeader = new SegmentHeader(ver, compacted);
            return segmentHeader;
        }
    }

    public static FileWALPointer readPosition(DataInput in) throws IOException {
        long idx = in.readLong();
        int fileOff = in.readInt();
        return new FileWALPointer(idx, fileOff, 0);
    }

    private static void putPositionOfRecord(ByteBuffer buf, WALRecord rec) {
        RecordV1Serializer.putPosition(buf, (FileWALPointer)rec.position());
    }

    static void putRecordType(ByteBuffer buf, WALRecord rec) {
        buf.put((byte)(rec.type().ordinal() + 1));
    }

    static WALRecord.RecordType readRecordType(DataInput in) throws IgniteCheckedException, IOException {
        int type = in.readUnsignedByte();
        if (type == 0) {
            throw new SegmentEofException("Reached logical end of the segment", null);
        }
        WALRecord.RecordType recType = WALRecord.RecordType.fromOrdinal(type - 1);
        if (recType == null) {
            throw new IOException("Unknown record type: " + type);
        }
        return recType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static WALRecord readWithCrc(FileInput in0, WALPointer expPtr, RecordIO reader) throws EOFException, IgniteCheckedException {
        long startPos = -1L;
        try (FileInput.Crc32CheckingFileInput in = in0.startRead(skipCrc);){
            startPos = in0.position();
            WALRecord res = reader.readWithHeaders(in, expPtr);
            assert (res != null);
            res.size((int)(in0.position() - startPos + 4L));
            WALRecord wALRecord = res;
            return wALRecord;
        }
        catch (EOFException | SegmentEofException | WalSegmentTailReachedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to read WAL record at position: " + startPos, e);
        }
    }

    static void writeWithCrc(WALRecord rec, ByteBuffer buf, RecordIO writer) throws IgniteCheckedException {
        assert (rec.size() >= 0 && buf.remaining() >= rec.size()) : rec.size();
        boolean switchSegmentRec = rec.type() == WALRecord.RecordType.SWITCH_SEGMENT_RECORD;
        int startPos = buf.position();
        writer.writeWithHeaders(rec, buf);
        if (switchSegmentRec) {
            return;
        }
        if (!skipCrc) {
            int curPos = buf.position();
            buf.position(startPos);
            int crcVal = PureJavaCrc32.calcCrc32(buf, curPos - startPos);
            buf.putInt(crcVal);
        } else {
            buf.putInt(0);
        }
    }

    static void putVersion(ByteBuffer buf, GridCacheVersion ver, boolean allowNull) {
        CacheVersionIO.write(buf, ver, allowNull);
    }

    static GridCacheVersion readVersion(ByteBufferBackedDataInput in, boolean allowNull) throws IOException {
        in.ensure(1);
        try {
            int size = CacheVersionIO.readSize(in.buffer(), allowNull);
            in.ensure(size);
            return CacheVersionIO.read(in.buffer(), allowNull);
        }
        catch (IgniteCheckedException e) {
            throw new IOException(e);
        }
    }
}

