/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.version;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridCacheVersion
implements Message,
Comparable<GridCacheVersion>,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static final int NODE_ORDER_MASK = 0x7FFFFFF;
    private static final int DR_ID_SHIFT = 27;
    private static final int DR_ID_MASK = 31;
    private int topVer;
    private int nodeOrderDrId;
    private long order;

    public GridCacheVersion() {
    }

    public GridCacheVersion(int topVer, long order, int nodeOrder, int dataCenterId) {
        assert (topVer >= 0) : topVer;
        assert (order >= 0L) : order;
        assert (nodeOrder >= 0) : nodeOrder;
        assert (dataCenterId < 32 && dataCenterId >= 0) : dataCenterId;
        if (nodeOrder > 0x7FFFFFF) {
            throw new IllegalArgumentException("Node order overflow: " + nodeOrder);
        }
        this.topVer = topVer;
        this.order = order;
        this.nodeOrderDrId = nodeOrder | dataCenterId << 27;
    }

    public GridCacheVersion(int topVer, int nodeOrderDrId, long order) {
        this.topVer = topVer;
        this.nodeOrderDrId = nodeOrderDrId;
        this.order = order;
    }

    public int topologyVersion() {
        return this.topVer;
    }

    public int nodeOrderAndDrIdRaw() {
        return this.nodeOrderDrId;
    }

    public long order() {
        return this.order;
    }

    public int nodeOrder() {
        return this.nodeOrderDrId & 0x7FFFFFF;
    }

    public byte dataCenterId() {
        return (byte)(this.nodeOrderDrId >> 27 & 0x1F);
    }

    public GridCacheVersion conflictVersion() {
        return this;
    }

    public boolean isGreater(GridCacheVersion ver) {
        return this.compareTo(ver) > 0;
    }

    public boolean isGreaterEqual(GridCacheVersion ver) {
        return this.compareTo(ver) >= 0;
    }

    public boolean isLess(GridCacheVersion ver) {
        return this.compareTo(ver) < 0;
    }

    public boolean isLessEqual(GridCacheVersion ver) {
        return this.compareTo(ver) <= 0;
    }

    public IgniteUuid asGridUuid() {
        return new IgniteUuid(new UUID(this.topVer, this.nodeOrderDrId), this.order);
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.topVer);
        out.writeLong(this.order);
        out.writeInt(this.nodeOrderDrId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.topVer = in.readInt();
        this.order = in.readLong();
        this.nodeOrderDrId = in.readInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GridCacheVersion)) {
            return false;
        }
        GridCacheVersion that = (GridCacheVersion)o;
        return this.topVer == that.topVer && this.order == that.order && this.nodeOrder() == that.nodeOrder();
    }

    public int hashCode() {
        int res = this.topVer;
        res = 31 * res + this.nodeOrder();
        res = 31 * res + (int)(this.order ^ this.order >>> 32);
        return res;
    }

    @Override
    public int compareTo(GridCacheVersion other) {
        int res = Integer.compare(this.topologyVersion(), other.topologyVersion());
        if (res != 0) {
            return res;
        }
        res = Long.compare(this.order, other.order);
        if (res != 0) {
            return res;
        }
        return Integer.compare(this.nodeOrder(), other.nodeOrder());
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeInt("nodeOrderDrId", this.nodeOrderDrId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeLong("order", this.order)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeInt("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.nodeOrderDrId = reader.readInt("nodeOrderDrId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.order = reader.readLong("order");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.topVer = reader.readInt("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridCacheVersion.class);
    }

    @Override
    public short directType() {
        return 86;
    }

    @Override
    public byte fieldsCount() {
        return 3;
    }

    public String toString() {
        return "GridCacheVersion [topVer=" + this.topologyVersion() + ", order=" + this.order() + ", nodeOrder=" + this.nodeOrder() + ']';
    }
}

