/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc;

import java.net.InetAddress;
import java.nio.ByteOrder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import javax.cache.configuration.Factory;
import javax.net.ssl.SSLContext;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.ClientConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.OdbcConfiguration;
import org.apache.ignite.configuration.SqlConnectorConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.odbc.ClientConnectorConfigurationEx;
import org.apache.ignite.internal.processors.odbc.ClientListenerBufferedParser;
import org.apache.ignite.internal.processors.odbc.ClientListenerNioListener;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.HostAndPortRange;
import org.apache.ignite.internal.util.nio.GridNioAsyncNotifyFilter;
import org.apache.ignite.internal.util.nio.GridNioCodecFilter;
import org.apache.ignite.internal.util.nio.GridNioFilter;
import org.apache.ignite.internal.util.nio.GridNioServer;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.ssl.GridNioSslFilter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgnitePortProtocol;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientListenerProcessor
extends GridProcessorAdapter {
    public static final ClientConnectorConfiguration DFLT_CLI_CFG = new ClientConnectorConfigurationEx();
    private static final int DFLT_SELECTOR_CNT = Math.min(4, Runtime.getRuntime().availableProcessors());
    private static final boolean DFLT_TCP_DIRECT_BUF = false;
    private final GridSpinBusyLock busyLock = new GridSpinBusyLock();
    private GridNioServer<byte[]> srv;
    private ExecutorService execSvc;

    public ClientListenerProcessor(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public void start() throws IgniteCheckedException {
        IgniteConfiguration cfg = this.ctx.config();
        if (cfg.isDaemon()) {
            this.log.debug("Client connection configuration ignored for daemon node.");
            return;
        }
        ClientConnectorConfiguration cliConnCfg = this.prepareConfiguration(cfg);
        if (cliConnCfg != null) {
            try {
                InetAddress hostAddr;
                this.validateConfiguration(cliConnCfg);
                String host = cliConnCfg.getHost();
                if (host == null) {
                    host = cfg.getLocalHost();
                }
                try {
                    hostAddr = U.resolveLocalHost(host);
                }
                catch (Exception e) {
                    throw new IgniteCheckedException("Failed to resolve client connector host: " + host, e);
                }
                this.execSvc = new IgniteThreadPoolExecutor("client-connector", cfg.getIgniteInstanceName(), cliConnCfg.getThreadPoolSize(), cliConnCfg.getThreadPoolSize(), 0L, new LinkedBlockingQueue<Runnable>());
                Exception lastErr = null;
                int portTo = cliConnCfg.getPort() + cliConnCfg.getPortRange();
                if (portTo <= 0) {
                    portTo = Integer.MAX_VALUE;
                }
                GridNioFilter[] filters = this.makeFilters(cliConnCfg);
                int maxOpenCursors = cliConnCfg.getMaxOpenCursorsPerConnection();
                long idleTimeout = cliConnCfg.getIdleTimeout();
                for (int port = cliConnCfg.getPort(); port <= portTo && port <= 65535; ++port) {
                    try {
                        GridNioServer<byte[]> srv0 = GridNioServer.builder().address(hostAddr).port(port).listener(new ClientListenerNioListener(this.ctx, this.busyLock, cliConnCfg)).logger(this.log).selectorCount(DFLT_SELECTOR_CNT).igniteInstanceName(this.ctx.igniteInstanceName()).serverName("client-listener").tcpNoDelay(cliConnCfg.isTcpNoDelay()).directBuffer(false).byteOrder(ByteOrder.nativeOrder()).socketSendBufferSize(cliConnCfg.getSocketSendBufferSize()).socketReceiveBufferSize(cliConnCfg.getSocketReceiveBufferSize()).filters(filters).directMode(false).idleTimeout(idleTimeout > 0L ? idleTimeout : Long.MAX_VALUE).build();
                        srv0.start();
                        this.srv = srv0;
                        this.ctx.ports().registerPort(port, IgnitePortProtocol.TCP, this.getClass());
                        if (this.log.isInfoEnabled()) {
                            this.log.info("Client connector processor has started on TCP port " + port);
                        }
                        lastErr = null;
                        break;
                    }
                    catch (Exception e) {
                        lastErr = e;
                        continue;
                    }
                }
                assert (this.srv != null && lastErr == null || this.srv == null && lastErr != null);
                if (lastErr != null) {
                    throw new IgniteCheckedException("Failed to bind to any [host:port] from the range [host=" + host + ", portFrom=" + cliConnCfg.getPort() + ", portTo=" + portTo + ", lastErr=" + lastErr + ']');
                }
            }
            catch (Exception e) {
                throw new IgniteCheckedException("Failed to start client connector processor.", e);
            }
        }
    }

    @NotNull
    private GridNioFilter[] makeFilters(@NotNull ClientConnectorConfiguration cliConnCfg) throws IgniteCheckedException {
        GridNioAsyncNotifyFilter openSesFilter = new GridNioAsyncNotifyFilter(this.ctx.igniteInstanceName(), this.execSvc, this.log){

            @Override
            public void onSessionOpened(GridNioSession ses) throws IgniteCheckedException {
                this.proceedSessionOpened(ses);
            }
        };
        GridNioCodecFilter codecFilter = new GridNioCodecFilter(new ClientListenerBufferedParser(), this.log, false);
        if (cliConnCfg.isSslEnabled()) {
            Factory<SSLContext> sslCtxFactory;
            Factory<SSLContext> factory = sslCtxFactory = cliConnCfg.isUseIgniteSslContextFactory() ? this.ctx.config().getSslContextFactory() : cliConnCfg.getSslContextFactory();
            if (sslCtxFactory == null) {
                throw new IgniteCheckedException("Failed to create client listener (SSL is enabled but factory is null). Check the ClientConnectorConfiguration");
            }
            GridNioSslFilter sslFilter = new GridNioSslFilter((SSLContext)sslCtxFactory.create(), true, ByteOrder.nativeOrder(), this.log);
            sslFilter.directMode(false);
            boolean auth = cliConnCfg.isSslClientAuth();
            sslFilter.wantClientAuth(auth);
            sslFilter.needClientAuth(auth);
            return new GridNioFilter[]{openSesFilter, codecFilter, sslFilter};
        }
        return new GridNioFilter[]{openSesFilter, codecFilter};
    }

    @Override
    public void onKernalStop(boolean cancel) {
        if (this.srv != null) {
            this.busyLock.block();
            this.srv.stop();
            this.ctx.ports().deregisterPorts(this.getClass());
            if (this.execSvc != null) {
                U.shutdownNow(this.getClass(), this.execSvc, this.log);
                this.execSvc = null;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Client connector processor stopped.");
            }
        }
    }

    public int port() {
        return this.srv.port();
    }

    @Nullable
    private ClientConnectorConfiguration prepareConfiguration(IgniteConfiguration cfg) throws IgniteCheckedException {
        OdbcConfiguration odbcCfg = cfg.getOdbcConfiguration();
        SqlConnectorConfiguration sqlConnCfg = cfg.getSqlConnectorConfiguration();
        ClientConnectorConfiguration cliConnCfg = cfg.getClientConnectorConfiguration();
        if (cliConnCfg == null && sqlConnCfg == null && odbcCfg == null) {
            return null;
        }
        if (ClientListenerProcessor.isNotDefault(cliConnCfg)) {
            if (odbcCfg != null) {
                U.warn(this.log, "Deprecated " + OdbcConfiguration.class.getSimpleName() + " will be ignored because " + ClientConnectorConfiguration.class.getSimpleName() + " is set.");
            }
            if (sqlConnCfg != null) {
                U.warn(this.log, "Deprecated " + SqlConnectorConfiguration.class.getSimpleName() + " will be ignored " + "because " + ClientConnectorConfiguration.class.getSimpleName() + " is set.");
            }
        } else {
            cliConnCfg = new ClientConnectorConfiguration();
            if (sqlConnCfg != null) {
                cliConnCfg.setHost(sqlConnCfg.getHost());
                cliConnCfg.setMaxOpenCursorsPerConnection(sqlConnCfg.getMaxOpenCursorsPerConnection());
                cliConnCfg.setPort(sqlConnCfg.getPort());
                cliConnCfg.setPortRange(sqlConnCfg.getPortRange());
                cliConnCfg.setSocketSendBufferSize(sqlConnCfg.getSocketSendBufferSize());
                cliConnCfg.setSocketReceiveBufferSize(sqlConnCfg.getSocketReceiveBufferSize());
                cliConnCfg.setTcpNoDelay(sqlConnCfg.isTcpNoDelay());
                cliConnCfg.setThreadPoolSize(sqlConnCfg.getThreadPoolSize());
                U.warn(this.log, "Automatically converted deprecated " + SqlConnectorConfiguration.class.getSimpleName() + " to " + ClientConnectorConfiguration.class.getSimpleName() + ".");
                if (odbcCfg != null) {
                    U.warn(this.log, "Deprecated " + OdbcConfiguration.class.getSimpleName() + " will be ignored because " + SqlConnectorConfiguration.class.getSimpleName() + " is set.");
                }
            } else if (odbcCfg != null) {
                HostAndPortRange hostAndPort = this.parseOdbcEndpoint(odbcCfg);
                cliConnCfg.setHost(hostAndPort.host());
                cliConnCfg.setPort(hostAndPort.portFrom());
                cliConnCfg.setPortRange(hostAndPort.portTo() - hostAndPort.portFrom());
                cliConnCfg.setThreadPoolSize(odbcCfg.getThreadPoolSize());
                cliConnCfg.setSocketSendBufferSize(odbcCfg.getSocketSendBufferSize());
                cliConnCfg.setSocketReceiveBufferSize(odbcCfg.getSocketReceiveBufferSize());
                cliConnCfg.setMaxOpenCursorsPerConnection(odbcCfg.getMaxOpenCursors());
                U.warn(this.log, "Automatically converted deprecated " + OdbcConfiguration.class.getSimpleName() + " to " + ClientConnectorConfiguration.class.getSimpleName() + ".");
            }
        }
        return cliConnCfg;
    }

    private void validateConfiguration(ClientConnectorConfiguration cfg) throws IgniteCheckedException {
        this.assertParameter(cfg.getPort() > 1024, "port > 1024");
        this.assertParameter(cfg.getPort() <= 65535, "port <= 65535");
        this.assertParameter(cfg.getPortRange() >= 0, "portRange > 0");
        this.assertParameter(cfg.getSocketSendBufferSize() >= 0, "socketSendBufferSize > 0");
        this.assertParameter(cfg.getSocketReceiveBufferSize() >= 0, "socketReceiveBufferSize > 0");
        this.assertParameter(cfg.getMaxOpenCursorsPerConnection() >= 0, "maxOpenCursorsPerConnection() >= 0");
        this.assertParameter(cfg.getThreadPoolSize() > 0, "threadPoolSize > 0");
    }

    private HostAndPortRange parseOdbcEndpoint(OdbcConfiguration odbcCfg) throws IgniteCheckedException {
        HostAndPortRange res = F.isEmpty(odbcCfg.getEndpointAddress()) ? new HostAndPortRange("0.0.0.0", 10800, 10810) : HostAndPortRange.parse(odbcCfg.getEndpointAddress(), 10800, 10810, "Failed to parse ODBC endpoint address");
        return res;
    }

    private static boolean isNotDefault(ClientConnectorConfiguration cliConnCfg) {
        return cliConnCfg != null && !(cliConnCfg instanceof ClientConnectorConfigurationEx);
    }
}

