/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.List;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcBatchExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQuery;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.NotNull;

public class JdbcOrderedBatchExecuteRequest
extends JdbcBatchExecuteRequest
implements Comparable<JdbcOrderedBatchExecuteRequest> {
    private long order;

    public JdbcOrderedBatchExecuteRequest() {
        super((byte)14);
    }

    public JdbcOrderedBatchExecuteRequest(String schemaName, List<JdbcQuery> queries, boolean lastStreamBatch, long order) {
        super((byte)14, schemaName, queries, lastStreamBatch);
        this.order = order;
    }

    public long order() {
        return this.order;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer) throws BinaryObjectException {
        super.writeBinary(writer);
        writer.writeLong(this.order);
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader) throws BinaryObjectException {
        super.readBinary(reader);
        this.order = reader.readLong();
    }

    @Override
    public String toString() {
        return S.toString(JdbcOrderedBatchExecuteRequest.class, this);
    }

    @Override
    public int compareTo(@NotNull JdbcOrderedBatchExecuteRequest o) {
        return Long.compare(this.order, o.order);
    }
}

