/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.baseline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.baseline.VisorBaselineTaskArg;
import org.apache.ignite.internal.visor.baseline.VisorBaselineTaskResult;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorBaselineTask
extends VisorOneNodeTask<VisorBaselineTaskArg, VisorBaselineTaskResult> {
    private static final long serialVersionUID = 0L;

    protected VisorBaselineJob job(VisorBaselineTaskArg arg) {
        return new VisorBaselineJob(arg, this.debug);
    }

    private static class VisorBaselineJob
    extends VisorJob<VisorBaselineTaskArg, VisorBaselineTaskResult> {
        private static final long serialVersionUID = 0L;

        private VisorBaselineJob(VisorBaselineTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        private VisorBaselineTaskResult collect() {
            IgniteClusterEx cluster = this.ignite.cluster();
            Collection<BaselineNode> baseline = cluster.currentBaselineTopology();
            Collection<ClusterNode> srvrs = cluster.forServers().nodes();
            return new VisorBaselineTaskResult(this.ignite.cluster().active(), cluster.topologyVersion(), F.isEmpty(baseline) ? null : baseline, srvrs);
        }

        private VisorBaselineTaskResult set0(Collection<BaselineNode> baselineTop) {
            this.ignite.cluster().setBaselineTopology(baselineTop);
            return this.collect();
        }

        private Map<String, BaselineNode> currentBaseLine() {
            HashMap<String, BaselineNode> nodes = new HashMap<String, BaselineNode>();
            Collection<BaselineNode> baseline = this.ignite.cluster().currentBaselineTopology();
            if (!F.isEmpty(baseline)) {
                for (BaselineNode node : baseline) {
                    nodes.put(node.consistentId().toString(), node);
                }
            }
            return nodes;
        }

        private Map<String, BaselineNode> currentServers() {
            HashMap<String, BaselineNode> nodes = new HashMap<String, BaselineNode>();
            for (ClusterNode node : this.ignite.cluster().forServers().nodes()) {
                nodes.put(node.consistentId().toString(), node);
            }
            return nodes;
        }

        private VisorBaselineTaskResult set(List<String> consistentIds) {
            Map<String, BaselineNode> srvrs = this.currentServers();
            ArrayList<BaselineNode> baselineTop = new ArrayList<BaselineNode>();
            for (String consistentId : consistentIds) {
                BaselineNode node = srvrs.get(consistentId);
                if (node == null) {
                    throw new IllegalStateException("Node not found for consistent ID: " + consistentId);
                }
                baselineTop.add(node);
            }
            return this.set0(baselineTop);
        }

        private VisorBaselineTaskResult add(List<String> consistentIds) {
            Map<String, BaselineNode> baseline = this.currentBaseLine();
            Map<String, BaselineNode> srvrs = this.currentServers();
            for (String consistentId : consistentIds) {
                BaselineNode node = srvrs.get(consistentId);
                if (node == null) {
                    throw new IllegalStateException("Node not found for consistent ID: " + consistentId);
                }
                baseline.put(consistentId, node);
            }
            return this.set0(baseline.values());
        }

        private VisorBaselineTaskResult remove(List<String> consistentIds) {
            Map<String, BaselineNode> baseline = this.currentBaseLine();
            for (String consistentId : consistentIds) {
                BaselineNode node = baseline.remove(consistentId);
                if (node != null) continue;
                throw new IllegalStateException("Node not found for consistent ID: " + consistentId);
            }
            return this.set0(baseline.values());
        }

        private VisorBaselineTaskResult version(long targetVer) {
            IgniteClusterEx cluster = this.ignite.cluster();
            if (targetVer > cluster.topologyVersion()) {
                throw new IllegalArgumentException("Topology version is ahead of time: " + targetVer);
            }
            cluster.setBaselineTopology(targetVer);
            return this.collect();
        }

        @Override
        protected VisorBaselineTaskResult run(@Nullable VisorBaselineTaskArg arg) throws IgniteException {
            switch (arg.getOperation()) {
                case ADD: {
                    return this.add(arg.getConsistentIds());
                }
                case REMOVE: {
                    return this.remove(arg.getConsistentIds());
                }
                case SET: {
                    return this.set(arg.getConsistentIds());
                }
                case VERSION: {
                    return this.version(arg.getTopologyVersion());
                }
            }
            return this.collect();
        }

        public String toString() {
            return S.toString(VisorBaselineJob.class, this);
        }
    }
}

