/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterGroupEmptyException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.node.VisorNodeDataCollectorJob;
import org.apache.ignite.internal.visor.node.VisorNodeDataCollectorJobResult;
import org.apache.ignite.internal.visor.node.VisorNodeDataCollectorTaskArg;
import org.apache.ignite.internal.visor.node.VisorNodeDataCollectorTaskResult;
import org.apache.ignite.internal.visor.util.VisorExceptionWrapper;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorNodeDataCollectorTask
extends VisorMultiNodeTask<VisorNodeDataCollectorTaskArg, VisorNodeDataCollectorTaskResult, VisorNodeDataCollectorJobResult> {
    private static final long serialVersionUID = 0L;

    protected VisorNodeDataCollectorJob job(VisorNodeDataCollectorTaskArg arg) {
        return new VisorNodeDataCollectorJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected VisorNodeDataCollectorTaskResult reduce0(List<ComputeJobResult> results) {
        return this.reduce(new VisorNodeDataCollectorTaskResult(), results);
    }

    protected VisorNodeDataCollectorTaskResult reduce(VisorNodeDataCollectorTaskResult taskRes, List<ComputeJobResult> results) {
        for (ComputeJobResult res : results) {
            VisorNodeDataCollectorJobResult jobRes = (VisorNodeDataCollectorJobResult)res.getData();
            if (jobRes == null) continue;
            UUID nid = res.getNode().id();
            IgniteException unhandledEx = res.getException();
            if (unhandledEx == null) {
                this.reduceJobResult(taskRes, jobRes, nid);
                continue;
            }
            if (unhandledEx instanceof ClusterGroupEmptyException) continue;
            taskRes.getUnhandledEx().put(nid, new VisorExceptionWrapper(unhandledEx));
        }
        taskRes.setActive(this.ignite.active());
        return taskRes;
    }

    protected void reduceJobResult(VisorNodeDataCollectorTaskResult taskRes, VisorNodeDataCollectorJobResult jobRes, UUID nid) {
        taskRes.getGridNames().put(nid, jobRes.getGridName());
        taskRes.getTopologyVersions().put(nid, jobRes.getTopologyVersion());
        taskRes.getTaskMonitoringEnabled().put(nid, jobRes.isTaskMonitoringEnabled());
        taskRes.getErrorCounts().put(nid, jobRes.getErrorCount());
        if (!F.isEmpty(jobRes.getEvents())) {
            taskRes.getEvents().addAll(jobRes.getEvents());
        }
        if (jobRes.getEventsEx() != null) {
            taskRes.getEventsEx().put(nid, jobRes.getEventsEx());
        }
        if (!F.isEmpty(jobRes.getMemoryMetrics())) {
            taskRes.getMemoryMetrics().put(nid, jobRes.getMemoryMetrics());
        }
        if (jobRes.getMemoryMetricsEx() != null) {
            taskRes.getMemoryMetricsEx().put(nid, jobRes.getMemoryMetricsEx());
        }
        if (!F.isEmpty(jobRes.getCaches())) {
            taskRes.getCaches().put(nid, jobRes.getCaches());
        }
        if (jobRes.getCachesEx() != null) {
            taskRes.getCachesEx().put(nid, jobRes.getCachesEx());
        }
        if (!F.isEmpty(jobRes.getIgfss())) {
            taskRes.getIgfss().put(nid, jobRes.getIgfss());
        }
        if (!F.isEmpty(jobRes.getIgfsEndpoints())) {
            taskRes.getIgfsEndpoints().put(nid, jobRes.getIgfsEndpoints());
        }
        if (jobRes.getIgfssEx() != null) {
            taskRes.getIgfssEx().put(nid, jobRes.getIgfssEx());
        }
        if (jobRes.getPersistenceMetrics() != null) {
            taskRes.getPersistenceMetrics().put(nid, jobRes.getPersistenceMetrics());
        }
        if (jobRes.getPersistenceMetricsEx() != null) {
            taskRes.getPersistenceMetricsEx().put(nid, jobRes.getPersistenceMetricsEx());
        }
        taskRes.getReadyAffinityVersions().put(nid, jobRes.getReadyAffinityVersion());
        taskRes.getPendingExchanges().put(nid, jobRes.isHasPendingExchange());
        taskRes.getRebalance().put(nid, jobRes.getRebalance());
    }
}

