/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.query;

import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.query.VisorQueryCursor;
import org.apache.ignite.internal.visor.query.VisorQueryNextPageTaskArg;
import org.apache.ignite.internal.visor.query.VisorQueryResult;
import org.apache.ignite.internal.visor.query.VisorQueryUtils;

@GridInternal
public class VisorQueryNextPageTask
extends VisorOneNodeTask<VisorQueryNextPageTaskArg, VisorQueryResult> {
    private static final long serialVersionUID = 0L;

    protected VisorQueryNextPageJob job(VisorQueryNextPageTaskArg arg) {
        return new VisorQueryNextPageJob(arg, this.debug);
    }

    private static class VisorQueryNextPageJob
    extends VisorJob<VisorQueryNextPageTaskArg, VisorQueryResult> {
        private static final long serialVersionUID = 0L;

        private VisorQueryNextPageJob(VisorQueryNextPageTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorQueryResult run(VisorQueryNextPageTaskArg arg) {
            return arg.getQueryId().startsWith("VISOR_SCAN_QUERY") ? this.nextScanPage(arg) : this.nextSqlPage(arg);
        }

        private VisorQueryResult nextSqlPage(VisorQueryNextPageTaskArg arg) {
            String qryId;
            long start = U.currentTimeMillis();
            ConcurrentMap storage = this.ignite.cluster().nodeLocalMap();
            VisorQueryCursor cur = (VisorQueryCursor)storage.get(qryId = arg.getQueryId());
            if (cur == null) {
                throw new IgniteException("SQL query results are expired.");
            }
            List<Object[]> nextRows = VisorQueryUtils.fetchSqlQueryRows(cur, arg.getPageSize());
            boolean hasMore = cur.hasNext();
            if (hasMore) {
                cur.accessed(true);
            } else {
                storage.remove(qryId);
                cur.close();
            }
            return new VisorQueryResult(this.ignite.localNode().id(), qryId, null, nextRows, hasMore, U.currentTimeMillis() - start);
        }

        private VisorQueryResult nextScanPage(VisorQueryNextPageTaskArg arg) {
            String qryId;
            long start = U.currentTimeMillis();
            ConcurrentMap storage = this.ignite.cluster().nodeLocalMap();
            VisorQueryCursor cur = (VisorQueryCursor)storage.get(qryId = arg.getQueryId());
            if (cur == null) {
                throw new IgniteException("Scan query results are expired.");
            }
            List<Object[]> rows = VisorQueryUtils.fetchScanQueryRows(cur, arg.getPageSize());
            boolean hasMore = cur.hasNext();
            if (hasMore) {
                cur.accessed(true);
            } else {
                storage.remove(qryId);
                cur.close();
            }
            return new VisorQueryResult(this.ignite.localNode().id(), qryId, null, rows, hasMore, U.currentTimeMillis() - start);
        }

        public String toString() {
            return S.toString(VisorQueryNextPageJob.class, this);
        }
    }
}

