/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.util.split;

import com.sagacloud.util.compute_engine.util.DoubleTimeObject;
import java.util.Calendar;
import java.util.List;

public class HistoryUtil {
    private static HistoryUtil instance = new HistoryUtil();

    public static HistoryUtil Instance() {
        return instance;
    }

    private HistoryUtil() {
    }

    public void GetHistory(List<DoubleTimeObject> serviceDataList, List<Double> estimateList, List<Double> uncertaintyList) {
        int indexHour;
        int hour_of_day;
        int day_of_week;
        DoubleTimeObject objectDataPtr;
        int i;
        Calendar calendar = Calendar.getInstance();
        double[] sumOfValue = new double[168];
        double[] averageOfValue = new double[168];
        double[] sumOfSquares = new double[168];
        int[] count = new int[168];
        int[] estimateUsed = new int[168];
        for (i = 0; i < 168; ++i) {
            sumOfValue[i] = 0.0;
            averageOfValue[i] = 0.0;
            sumOfSquares[i] = 0.0;
            count[i] = 0;
            estimateUsed[i] = 0;
        }
        for (i = 0; i < serviceDataList.size(); ++i) {
            objectDataPtr = serviceDataList.get(i);
            calendar.setTime(objectDataPtr.data_time);
            day_of_week = calendar.get(7);
            hour_of_day = calendar.get(11);
            int n = indexHour = (day_of_week - 1) * 24 + hour_of_day;
            sumOfValue[n] = sumOfValue[n] + objectDataPtr.data_value;
            int n2 = indexHour;
            count[n2] = count[n2] + 1;
        }
        for (i = 0; i < 168; ++i) {
            if (count[i] <= 0) continue;
            averageOfValue[i] = sumOfValue[i] / (double)count[i];
        }
        for (i = 0; i < serviceDataList.size(); ++i) {
            objectDataPtr = serviceDataList.get(i);
            calendar.setTime(objectDataPtr.data_time);
            day_of_week = calendar.get(7);
            hour_of_day = calendar.get(11);
            indexHour = (day_of_week - 1) * 24 + hour_of_day;
            double pingfang = Math.pow(objectDataPtr.data_value - averageOfValue[indexHour], 2.0);
            int n = indexHour;
            sumOfSquares[n] = sumOfSquares[n] + pingfang;
        }
        for (i = 0; i < 168; ++i) {
            if (count[i] > 0) {
                estimateList.add(averageOfValue[i]);
                uncertaintyList.add(Math.sqrt(sumOfSquares[i] / (double)count[i]));
                continue;
            }
            estimateList.add(null);
            uncertaintyList.add(null);
        }
    }
}

