/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.spi.IgniteSpiTimeoutObject;

abstract class ZkTimeoutObject
implements IgniteSpiTimeoutObject {
    private final IgniteUuid id = IgniteUuid.randomUuid();
    private final long endTime;
    volatile boolean cancelled;

    ZkTimeoutObject(long timeout) {
        long endTime = timeout >= 0L ? System.currentTimeMillis() + timeout : Long.MAX_VALUE;
        this.endTime = endTime >= 0L ? endTime : Long.MAX_VALUE;
    }

    public final IgniteUuid id() {
        return this.id;
    }

    public final long endTime() {
        return this.endTime;
    }
}

