/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.api.request;

import com.dingtalk.api.response.CorpDingCreateResponse;
import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorpDingCreateRequest
extends BaseTaobaoRequest<CorpDingCreateResponse> {
    private String attachment;
    private String creatorUserid;
    private String receiverUserids;
    private Long remindTime;
    private Long remindType;
    private String textContent;
    private String topResponseType;
    private String topHttpMethod = "POST";

    public void setAttachment(String attachment) {
        this.attachment = attachment;
    }

    public void setAttachment(AttachmentVO attachment) {
        this.attachment = new JSONWriter(false, true).write(attachment);
    }

    public String getAttachment() {
        return this.attachment;
    }

    public void setCreatorUserid(String creatorUserid) {
        this.creatorUserid = creatorUserid;
    }

    public String getCreatorUserid() {
        return this.creatorUserid;
    }

    public void setReceiverUserids(String receiverUserids) {
        this.receiverUserids = receiverUserids;
    }

    public String getReceiverUserids() {
        return this.receiverUserids;
    }

    public void setRemindTime(Long remindTime) {
        this.remindTime = remindTime;
    }

    public Long getRemindTime() {
        return this.remindTime;
    }

    public void setRemindType(Long remindType) {
        this.remindType = remindType;
    }

    public Long getRemindType() {
        return this.remindType;
    }

    public void setTextContent(String textContent) {
        this.textContent = textContent;
    }

    public String getTextContent() {
        return this.textContent;
    }

    @Override
    public String getApiMethodName() {
        return "dingtalk.corp.ding.create";
    }

    @Override
    public String getTopResponseType() {
        return this.topResponseType;
    }

    @Override
    public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
    }

    @Override
    public String getTopApiCallType() {
        return "top";
    }

    @Override
    public String getTopHttpMethod() {
        return this.topHttpMethod;
    }

    @Override
    public void setTopHttpMethod(String topHttpMethod) {
        this.topHttpMethod = topHttpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.setTopHttpMethod(httpMethod);
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("attachment", this.attachment);
        txtParams.put("creator_userid", this.creatorUserid);
        txtParams.put("receiver_userids", this.receiverUserids);
        txtParams.put("remind_time", (Object)this.remindTime);
        txtParams.put("remind_type", (Object)this.remindType);
        txtParams.put("text_content", this.textContent);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<CorpDingCreateResponse> getResponseClass() {
        return CorpDingCreateResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.creatorUserid, "creatorUserid");
        RequestCheckUtils.checkNotEmpty(this.receiverUserids, "receiverUserids");
        RequestCheckUtils.checkMaxListSize(this.receiverUserids, 20, "receiverUserids");
        RequestCheckUtils.checkNotEmpty(this.remindTime, "remindTime");
        RequestCheckUtils.checkNotEmpty(this.remindType, "remindType");
        RequestCheckUtils.checkNotEmpty(this.textContent, "textContent");
        RequestCheckUtils.checkMaxLength(this.textContent, 5000, "textContent");
    }

    public static class AttachmentVO
    extends TaobaoObject {
        private static final long serialVersionUID = 4887776343932356358L;
        @ApiField(value="detail_type")
        private String detailType;
        @ApiField(value="file_id")
        private String fileId;
        @ApiField(value="file_name")
        private String fileName;
        @ApiField(value="file_size")
        private Long fileSize;
        @ApiField(value="file_space_id")
        private String fileSpaceId;
        @ApiField(value="link_pic_url")
        private String linkPicUrl;
        @ApiField(value="link_text")
        private String linkText;
        @ApiField(value="link_title")
        private String linkTitle;
        @ApiField(value="link_url")
        private String linkUrl;
        @ApiField(value="type")
        private String type;

        public String getDetailType() {
            return this.detailType;
        }

        public void setDetailType(String detailType) {
            this.detailType = detailType;
        }

        public String getFileId() {
            return this.fileId;
        }

        public void setFileId(String fileId) {
            this.fileId = fileId;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public Long getFileSize() {
            return this.fileSize;
        }

        public void setFileSize(Long fileSize) {
            this.fileSize = fileSize;
        }

        public String getFileSpaceId() {
            return this.fileSpaceId;
        }

        public void setFileSpaceId(String fileSpaceId) {
            this.fileSpaceId = fileSpaceId;
        }

        public String getLinkPicUrl() {
            return this.linkPicUrl;
        }

        public void setLinkPicUrl(String linkPicUrl) {
            this.linkPicUrl = linkPicUrl;
        }

        public String getLinkText() {
            return this.linkText;
        }

        public void setLinkText(String linkText) {
            this.linkText = linkText;
        }

        public String getLinkTitle() {
            return this.linkTitle;
        }

        public void setLinkTitle(String linkTitle) {
            this.linkTitle = linkTitle;
        }

        public String getLinkUrl() {
            return this.linkUrl;
        }

        public void setLinkUrl(String linkUrl) {
            this.linkUrl = linkUrl;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

