/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.embedded.websocket.handshake;

import com.taobao.api.internal.toplink.embedded.websocket.WebSocket;
import com.taobao.api.internal.toplink.embedded.websocket.exception.ErrorCode;
import com.taobao.api.internal.toplink.embedded.websocket.exception.WebSocketException;
import com.taobao.api.internal.toplink.embedded.websocket.handshake.X509AlwaysTrustManager;
import com.taobao.api.internal.toplink.embedded.websocket.util.PacketDumpUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;

public class SSLHandshake {
    private static Logger log = Logger.getLogger(SSLHandshake.class.getName());
    private SSLContext ctx;
    private SSLEngine engine;
    private ExecutorService delegatedTaskExecutor;
    private int currentBufferSize;
    private Selector selector;
    private SocketChannel socket;
    private static final int BUFFER_UNDERFLOW_MAX_RETRY_COUNT = 5;
    private int increaseBufferCount = 1;
    private WebSocket webSocket;

    public SSLHandshake(InetSocketAddress endpoint, WebSocket webSocket) throws WebSocketException {
        try {
            this.ctx = SSLContext.getInstance("TLS");
            this.ctx.init(null, new TrustManager[]{new X509AlwaysTrustManager()}, null);
            this.engine = this.ctx.createSSLEngine(endpoint.getHostName(), endpoint.getPort());
            this.engine.setUseClientMode(true);
            this.currentBufferSize = this.engine.getSession().getPacketBufferSize();
            this.webSocket = webSocket;
        }
        catch (NoSuchAlgorithmException e) {
            throw new WebSocketException(ErrorCode.E3810, (Throwable)e);
        }
        catch (KeyManagementException e) {
            throw new WebSocketException(ErrorCode.E3812, (Throwable)e);
        }
        this.delegatedTaskExecutor = Executors.newCachedThreadPool(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "SSL DelegateTask");
                t.setDaemon(true);
                return t;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doHandshake(SocketChannel socket) throws WebSocketException {
        this.socket = socket;
        try {
            try {
                this.selector = Selector.open();
                this.socket.register(this.selector, 1);
                this.engine.beginHandshake();
                HandshakeBuffer hb = new HandshakeBuffer();
                block14: while (true) {
                    SSLEngineResult.HandshakeStatus haStatus = this.engine.getHandshakeStatus();
                    if (log.isLoggable(Level.FINER)) {
                        log.finer("SSL HandshakeStatus: " + (Object)((Object)haStatus));
                    }
                    switch (haStatus) {
                        case NEED_WRAP: {
                            hb.netBuffer.clear();
                            this.doCallbackIncreaseBufferProcess(new HandshakeCallback(){

                                public SSLEngineResult execute(HandshakeBuffer hb) throws SSLException {
                                    return SSLHandshake.this.engine.wrap(hb.localBuffer, hb.netBuffer);
                                }
                            }, hb);
                            hb.netBuffer.flip();
                            if (!hb.netBuffer.hasRemaining()) continue block14;
                            if (PacketDumpUtil.isDump(this.webSocket, 8)) {
                                PacketDumpUtil.printPacketDump("SSL_HS_UP", hb.netBuffer);
                            }
                            socket.write(hb.netBuffer);
                            hb.netBuffer.clear();
                            break;
                        }
                        case NEED_UNWRAP: {
                            this.selector.select();
                            socket.read(hb.netBuffer);
                            hb.netBuffer.flip();
                            if (PacketDumpUtil.isDump(this.webSocket, 2)) {
                                PacketDumpUtil.printPacketDump("SSL_HS_DOWN", hb.netBuffer);
                            }
                            SSLEngineResult res = null;
                            do {
                                res = this.doCallbackIncreaseBufferProcess(new HandshakeCallback(){

                                    public SSLEngineResult execute(HandshakeBuffer hb) throws SSLException {
                                        return SSLHandshake.this.engine.unwrap(hb.netBuffer, hb.localBuffer);
                                    }
                                }, hb);
                                if (this.increaseBufferCount <= 5) continue;
                                throw new WebSocketException(ErrorCode.E3820);
                            } while (res.getStatus() == SSLEngineResult.Status.OK && res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
                            break;
                        }
                        case NEED_TASK: {
                            this.runDelegatedTasks();
                            break;
                        }
                        case NOT_HANDSHAKING: 
                        case FINISHED: {
                            Object var6_7 = null;
                            try {
                                this.selector.close();
                                this.delegatedTaskExecutor.shutdown();
                                this.delegatedTaskExecutor = null;
                                return;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            return;
                        }
                    }
                }
            }
            catch (SSLException e) {
                throw new WebSocketException(ErrorCode.E3815, (Throwable)e);
            }
            catch (IOException ioe) {
                throw new WebSocketException(ErrorCode.E3816, (Throwable)ioe);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            this.selector.close();
            this.delegatedTaskExecutor.shutdown();
            this.delegatedTaskExecutor = null;
            throw throwable;
        }
    }

    protected SSLEngineResult doCallbackIncreaseBufferProcess(HandshakeCallback callback, HandshakeBuffer hb) throws SSLException, WebSocketException {
        SSLEngineResult res = null;
        do {
            res = callback.execute(hb);
            if (log.isLoggable(Level.FINER)) {
                log.finer("res: \n" + res);
                log.finer("buffer: " + hb);
            }
            if (res.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                this.increaseBuffer(hb, hb.localBuffer);
                continue;
            }
            if (res.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
            this.increaseBuffer(hb, hb.netBuffer);
        } while (res.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW);
        return res;
    }

    private void increaseBuffer(HandshakeBuffer hb, ByteBuffer buffer) throws WebSocketException {
        if (buffer.limit() == buffer.capacity()) {
            this.reallocateBuffer(hb);
        } else if (buffer.position() == buffer.limit()) {
            buffer.clear();
        } else {
            buffer.position(buffer.limit()).limit(buffer.capacity());
        }
    }

    private void reallocateBuffer(HandshakeBuffer hb) throws WebSocketException {
        if (this.increaseBufferCount > 5) {
            throw new WebSocketException(ErrorCode.E3821);
        }
        this.currentBufferSize = this.engine.getSession().getPacketBufferSize() * this.increaseBufferCount++;
        log.finer("Caught BUFFER_UNDERFLOW or BUFFER_OVERFLOW. reallocate internal buffer " + hb.netBuffer.capacity() + " -> " + this.currentBufferSize);
        hb.netBuffer.flip();
        ByteBuffer tmpNetBuffer = ByteBuffer.allocate(this.currentBufferSize);
        tmpNetBuffer.put(hb.netBuffer);
        hb.netBuffer = tmpNetBuffer;
        hb.localBuffer = ByteBuffer.allocate(this.currentBufferSize);
    }

    public void wrap(ByteBuffer localBuffer, ByteBuffer netBuffer) throws WebSocketException {
        try {
            netBuffer.clear();
            SSLEngineResult result = this.engine.wrap(localBuffer, netBuffer);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("SSLEngineResult\n" + result);
            }
            netBuffer.flip();
        }
        catch (SSLException e) {
            throw new WebSocketException(ErrorCode.E3817, (Throwable)e);
        }
    }

    public void unwrap(ByteBuffer netBuffer, ByteBuffer localBuffer) throws WebSocketException {
        try {
            localBuffer.clear();
            SSLEngineResult result = this.engine.unwrap(netBuffer, localBuffer);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("SSLEngineResult\n" + result);
            }
            localBuffer.flip();
        }
        catch (SSLException se) {
            throw new WebSocketException(ErrorCode.E3818, (Throwable)se);
        }
    }

    private void runDelegatedTasks() {
        Runnable task = null;
        while ((task = this.engine.getDelegatedTask()) != null) {
            this.delegatedTaskExecutor.execute(task);
        }
    }

    protected static interface HandshakeCallback {
        public SSLEngineResult execute(HandshakeBuffer var1) throws SSLException;
    }

    private class HandshakeBuffer {
        ByteBuffer netBuffer;
        ByteBuffer localBuffer;

        HandshakeBuffer() {
            this.netBuffer = ByteBuffer.allocate(SSLHandshake.this.currentBufferSize);
            this.localBuffer = ByteBuffer.allocate(SSLHandshake.this.currentBufferSize);
        }

        public String toString() {
            return "netBuffer: " + this.netBuffer + ", localBuffer: " + this.localBuffer;
        }
    }
}

