/*
 * Decompiled with CFR 0.152.
 */
package com.persagy.core.dto.analysis;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.persagy.core.annotation.Column;
import com.persagy.core.annotation.Entity;
import com.persagy.core.annotation.ForeignKey;
import com.persagy.core.annotation.Id;
import com.persagy.core.annotation.Index;
import com.persagy.core.annotation.Month;
import com.persagy.core.annotation.Order;
import com.persagy.core.annotation.Orders;
import com.persagy.core.annotation.Property;
import com.persagy.core.annotation.Redundant;
import com.persagy.core.annotation.Table;
import com.persagy.core.constant.SystemConstant;
import com.persagy.core.constant.SystemSetting;
import com.persagy.core.dto.analysis.EMSColumnAnalysis;
import com.persagy.core.dto.analysis.EMSEmbeddedAnalysis;
import com.persagy.core.dto.analysis.EMSEntityAnalysis;
import com.persagy.core.dto.analysis.EMSIndexAnalysis;
import com.persagy.core.dto.analysis.EMSRedundantAnalysis;
import com.persagy.core.dto.analysis.EMSTableAnalysis;
import com.persagy.core.enumeration.EMSOrder;
import com.persagy.core.mvc.dialect.DatabaseDialect;
import com.persagy.core.mvc.pojo.BusinessObject;
import com.persagy.core.utils.PackageScanUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class EMSAnalysis {
    private static Logger log = Logger.getLogger(EMSAnalysis.class);
    private static final String packageScan = "com.persagy.ems.pojo";
    @Resource
    private SystemSetting systemSetting;
    private static final Set<Class<?>> classSet = PackageScanUtils.getClasses("com.persagy.ems.pojo");
    private final Map<String, EMSEntityAnalysis> entityMap = new HashMap<String, EMSEntityAnalysis>();
    private Map<String, Map<String, Boolean>> keywordMap;

    public static Set<Class<?>> getClassSet() {
        return classSet;
    }

    public Map<String, EMSEntityAnalysis> getEntityMap() {
        return this.entityMap;
    }

    public EMSEntityAnalysis getEMSEntityAnalysis(String entityName) {
        return this.entityMap.get(entityName);
    }

    public EMSEntityAnalysis getEMSEntityAnalysis(Class<?> cls) {
        Entity entity = cls.getAnnotation(Entity.class);
        if (entity == null) {
            return null;
        }
        return this.entityMap.get(entity.name());
    }

    @PostConstruct
    private void init() throws Exception {
        log.info((Object)"********* ORM\u5bf9\u8c61\u5206\u6790\u5f00\u59cb ********");
        URL url = EMSAnalysis.class.getResource("keyword.json");
        try {
            this.setKeywordMap((Map)SystemConstant.jsonMapper.readValue(url, Map.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        DatabaseDialect databaseDialect = (DatabaseDialect)this.systemSetting.getContext().getBean(this.systemSetting.getJdbcDriverClass());
        for (Class<?> clazz : classSet) {
            PropertyDescriptor[] propertyDescriptorArray;
            Entity entity = clazz.getAnnotation(Entity.class);
            if (entity == null) continue;
            log.info((Object)("ORM\u5bf9\u8c61\u5206\u6790\uff1a" + clazz.getName()));
            EMSEntityAnalysis emsEntityAnalysis = new EMSEntityAnalysis();
            emsEntityAnalysis.setName(entity.name());
            emsEntityAnalysis.setCls(clazz);
            Table table = clazz.getAnnotation(Table.class);
            if (table == null) {
                throw new RuntimeException(String.valueOf(clazz.getName()) + "\u672a\u914d\u7f6e@Table");
            }
            for (Map.Entry<String, Map<String, Boolean>> databaseEntry : this.keywordMap.entrySet()) {
                Boolean isKeyword = databaseEntry.getValue().get(table.name().toLowerCase());
                if (isKeyword == null || !isKeyword.booleanValue()) continue;
                throw new RuntimeException("\u8868 " + table.name() + " \u4e3a " + databaseEntry.getKey() + " \u5173\u952e\u5b57\uff01");
            }
            EMSTableAnalysis emsTableAnalysis = new EMSTableAnalysis();
            emsTableAnalysis.setSchema(databaseDialect.getRealSchema(clazz));
            emsTableAnalysis.setName(table.name());
            emsTableAnalysis.setComment(table.comment());
            emsTableAnalysis.setTransaction(table.transaction());
            emsTableAnalysis.setCreated(false);
            emsEntityAnalysis.setTable(emsTableAnalysis);
            Month month = clazz.getAnnotation(Month.class);
            if (month != null) {
                emsTableAnalysis.setMonth(month.column());
            }
            LinkedHashMap<String, EMSEmbeddedAnalysis> embeddedMap = new LinkedHashMap<String, EMSEmbeddedAnalysis>();
            LinkedHashMap<String, EMSRedundantAnalysis> redundantMap = new LinkedHashMap<String, EMSRedundantAnalysis>();
            LinkedHashMap<String, EMSColumnAnalysis> columnMap = new LinkedHashMap<String, EMSColumnAnalysis>();
            BeanInfo bi = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] propertyDescriptorArray2 = propertyDescriptorArray = bi.getPropertyDescriptors();
            int n = propertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray2[n2];
                String propertyName = propertyDescriptor.getName();
                Field field = null;
                Class<?> tempClass = clazz;
                while (tempClass != null) {
                    try {
                        field = tempClass.getDeclaredField(propertyName);
                        break;
                    }
                    catch (Exception e) {
                        tempClass = tempClass.getSuperclass();
                    }
                }
                if (field != null) {
                    Redundant redundant = field.getAnnotation(Redundant.class);
                    if (redundant != null) {
                        Entity mainEntity = redundant.cls().getAnnotation(Entity.class);
                        JsonProperty jsonProperty = field.getAnnotation(JsonProperty.class);
                        EMSRedundantAnalysis redundantAnalysis = new EMSRedundantAnalysis();
                        redundantAnalysis.setForeignColumn(redundant.field());
                        redundantAnalysis.setMainEntity(mainEntity.name());
                        redundantAnalysis.setRedundantName(jsonProperty.value());
                        redundantAnalysis.setValueColumn(redundant.valueField());
                        redundantMap.put(propertyName, redundantAnalysis);
                    } else {
                        Object genericClass;
                        Method readMehtod;
                        Column column = field.getAnnotation(Column.class);
                        if (column == null && (column = (readMehtod = propertyDescriptor.getReadMethod()).getAnnotation(Column.class)) == null) {
                            Type type;
                            if (propertyDescriptor.getPropertyType() == List.class && (type = field.getGenericType()) instanceof ParameterizedType && ((Class)(genericClass = (Class)((ParameterizedType)type).getActualTypeArguments()[0])).newInstance() instanceof BusinessObject) {
                                Orders orders;
                                EMSEmbeddedAnalysis embeddedAnalysis = new EMSEmbeddedAnalysis();
                                Property property = field.getAnnotation(Property.class);
                                if (property != null) {
                                    embeddedAnalysis.setIsProperty(true);
                                }
                                if ((orders = field.getAnnotation(Orders.class)) != null) {
                                    LinkedHashMap<String, EMSOrder> orderMap = new LinkedHashMap<String, EMSOrder>();
                                    embeddedAnalysis.setOrderMap(orderMap);
                                    Order[] orderArray = orders.orders();
                                    int n3 = orderArray.length;
                                    int n4 = 0;
                                    while (n4 < n3) {
                                        Order order = orderArray[n4];
                                        orderMap.put(order.field(), order.order());
                                        ++n4;
                                    }
                                }
                                Entity mainEntity = ((Class)genericClass).getAnnotation(Entity.class);
                                embeddedAnalysis.setEmbeddedEntity(mainEntity.name());
                                embeddedMap.put(propertyName, embeddedAnalysis);
                            }
                        } else {
                            Id id = field.getAnnotation(Id.class);
                            if (id != null) {
                                emsTableAnalysis.setPrimaryKey(column.name());
                                emsTableAnalysis.setPrimaryKeyProperty(propertyName);
                            }
                            genericClass = this.keywordMap.entrySet().iterator();
                            while (genericClass.hasNext()) {
                                Map.Entry<String, Map<String, Boolean>> databaseEntry = genericClass.next();
                                Boolean isKeyword = databaseEntry.getValue().get(column.name().toLowerCase());
                                if (isKeyword == null || !isKeyword.booleanValue()) continue;
                                throw new RuntimeException(String.valueOf(table.name()) + " \u8868\u7684\u5b57\u6bb5 " + column.name() + " \u4e3a " + databaseEntry.getKey() + " \u5173\u952e\u5b57\uff01");
                            }
                            EMSColumnAnalysis emsColumnAnalysis = new EMSColumnAnalysis();
                            emsColumnAnalysis.setOrder(column.order());
                            emsColumnAnalysis.setName(column.name());
                            emsColumnAnalysis.setLength(column.length());
                            emsColumnAnalysis.setType(databaseDialect.getDatabaseColumnType(propertyDescriptor.getPropertyType(), column.length(), column.scale()));
                            emsColumnAnalysis.setScale(column.scale());
                            emsColumnAnalysis.setComment(column.comment());
                            emsColumnAnalysis.setNullable(column.nullable());
                            emsColumnAnalysis.setCreated(false);
                            ForeignKey foreignKey = field.getAnnotation(ForeignKey.class);
                            if (foreignKey != null) {
                                Entity mainEntity = foreignKey.mainClass().getAnnotation(Entity.class);
                                emsColumnAnalysis.setMainEntity(mainEntity.name());
                            }
                            columnMap.put(propertyName, emsColumnAnalysis);
                        }
                    }
                }
                ++n2;
            }
            if (columnMap.size() == 0) {
                throw new RuntimeException(String.valueOf(clazz.getName()) + "\u672a\u914d\u7f6e@Column");
            }
            emsTableAnalysis.setColumnMap(columnMap);
            emsTableAnalysis.setRedundantMap(redundantMap);
            emsTableAnalysis.setEmbeddedMap(embeddedMap);
            ArrayList<EMSIndexAnalysis> indexList = new ArrayList<EMSIndexAnalysis>();
            Index[] indexArray = table.indexes();
            int n5 = indexArray.length;
            n = 0;
            while (n < n5) {
                Index index = indexArray[n];
                if (index.columns().length == 0) {
                    throw new RuntimeException(String.valueOf(clazz.getName()) + "\u914d\u7f6e@Index\u5fc5\u987b\u5305\u542b\u81f3\u5c11\u4e00\u4e2a\u5b57\u6bb5");
                }
                List<String> columnList = Arrays.asList(index.columns());
                EMSIndexAnalysis emsIndexAnalysis = new EMSIndexAnalysis();
                emsIndexAnalysis.setUnique(index.unique());
                emsIndexAnalysis.setColumnList(columnList);
                emsIndexAnalysis.setCreated(false);
                indexList.add(emsIndexAnalysis);
                ++n;
            }
            emsTableAnalysis.setIndexList(indexList);
            this.entityMap.put(entity.name(), emsEntityAnalysis);
        }
        for (Map.Entry entry : this.entityMap.entrySet()) {
            EMSEntityAnalysis entityAnalysis = (EMSEntityAnalysis)entry.getValue();
            EMSTableAnalysis tableAnalysis = entityAnalysis.getTable();
            for (Map.Entry<String, EMSRedundantAnalysis> entry2 : tableAnalysis.getRedundantMap().entrySet()) {
                EMSRedundantAnalysis redundantAnalysis = entry2.getValue();
                String valueColumn = this.entityMap.get(redundantAnalysis.getMainEntity()).getTable().getColumnMap().get(redundantAnalysis.getValueColumn()).getName();
                redundantAnalysis.setValueColumn(valueColumn);
                String foreignColumn = tableAnalysis.getColumnMap().get(redundantAnalysis.getForeignColumn()).getName();
                redundantAnalysis.setForeignColumn(foreignColumn);
            }
            for (Map.Entry<String, Object> entry3 : tableAnalysis.getEmbeddedMap().entrySet()) {
                EMSEmbeddedAnalysis embeddedAnalysis = (EMSEmbeddedAnalysis)entry3.getValue();
                String embeddedEntity = embeddedAnalysis.getEmbeddedEntity();
                for (Map.Entry<String, EMSColumnAnalysis> columnEntry : this.entityMap.get(embeddedEntity).getTable().getColumnMap().entrySet()) {
                    EMSColumnAnalysis columnAnalysis = columnEntry.getValue();
                    if (!entityAnalysis.getName().equals(columnAnalysis.getMainEntity())) continue;
                    embeddedAnalysis.setForeignKey(columnAnalysis.getName());
                    embeddedAnalysis.setForeignKeyProperty(columnEntry.getKey());
                }
            }
        }
        log.info((Object)"********* ORM\u5bf9\u8c61\u5206\u6790\u7ed3\u675f ********");
        databaseDialect.init();
    }

    public Map<String, Map<String, Boolean>> getKeywordMap() {
        return this.keywordMap;
    }

    private void setKeywordMap(Map<String, Map<String, Boolean>> keywordMap) {
        this.keywordMap = keywordMap;
    }
}

