/*
 * Decompiled with CFR 0.152.
 */
package com.persagy.core.mvc.dao.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.persagy.core.annotation.Column;
import com.persagy.core.annotation.Entity;
import com.persagy.core.annotation.Redundant;
import com.persagy.core.constant.SystemSetting;
import com.persagy.core.dto.analysis.EMSAnalysis;
import com.persagy.core.dto.analysis.EMSEmbeddedAnalysis;
import com.persagy.core.dto.analysis.EMSTableAnalysis;
import com.persagy.core.dto.build.EMSCriteria;
import com.persagy.core.dto.build.EMSInsert;
import com.persagy.core.dto.build.EMSTable;
import com.persagy.core.dto.build.EMSUpdate;
import com.persagy.core.enumeration.EMSOrder;
import com.persagy.core.enumeration.SpecialOperator;
import com.persagy.core.mvc.dao.CoreDao;
import com.persagy.core.mvc.dialect.DatabaseDialect;
import com.persagy.core.mvc.pojo.BusinessObject;
import com.persagy.core.utils.BusinessObjectUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository(value="jdbcTemplateCoreDao")
public class CoreDaoImpl
implements CoreDao {
    private static Logger log = Logger.getLogger(CoreDaoImpl.class);
    @Resource(name="jdbcTemplate")
    protected JdbcTemplate jdbcTemplate;
    @Resource
    protected SystemSetting systemSetting;
    protected DatabaseDialect databaseDialect;
    @Resource
    protected BusinessObjectUtils businessObjectUtils;
    @Resource
    private EMSAnalysis analysis;

    @PostConstruct
    public void init() throws Exception {
        this.databaseDialect = (DatabaseDialect)this.systemSetting.getContext().getBean(this.systemSetting.getJdbcDriverClass());
    }

    @Override
    public int executeUpdate(String sql, List<Object> args) throws Exception {
        if (args == null) {
            args = new ArrayList<Object>();
        }
        return this.jdbcTemplate.update(sql, args.toArray());
    }

    @Override
    public List<Map<String, Object>> queryBySql(String sql, List<Object> args) throws Exception {
        if (args == null) {
            args = new ArrayList<Object>();
        }
        return this.jdbcTemplate.queryForList(sql, args.toArray());
    }

    @Override
    public <T extends BusinessObject> List<T> query(String sql, List<Object> args, final Class<T> cls) throws Exception {
        List list = this.jdbcTemplate.query(sql, args.toArray(), new RowMapper<T>(){

            public T mapRow(ResultSet rs, int rowNum) throws SQLException {
                BusinessObject mapper = null;
                try {
                    PropertyDescriptor[] propertyList;
                    mapper = (BusinessObject)cls.newInstance();
                    BeanInfo bi = Introspector.getBeanInfo(cls);
                    PropertyDescriptor[] propertyDescriptorArray = propertyList = bi.getPropertyDescriptors();
                    int n = propertyList.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PropertyDescriptor property = propertyDescriptorArray[n2];
                        Field field = null;
                        Class tempClass = cls;
                        while (tempClass != null) {
                            try {
                                field = tempClass.getDeclaredField(property.getName());
                                break;
                            }
                            catch (Exception e) {
                                tempClass = tempClass.getSuperclass();
                            }
                        }
                        if (field != null) {
                            Column column = field.getAnnotation(Column.class);
                            if (column == null) {
                                Method readMethod = property.getReadMethod();
                                column = readMethod.getAnnotation(Column.class);
                            }
                            Class<?> type = property.getPropertyType();
                            if (column != null) {
                                Method writeMethod = property.getWriteMethod();
                                Object columnValue = null;
                                if (rs.getObject(column.name()) != null) {
                                    if (type.equals(Integer.class)) {
                                        columnValue = rs.getInt(column.name());
                                    } else if (type.equals(Long.class)) {
                                        columnValue = rs.getLong(column.name());
                                    } else if (type.equals(Double.class)) {
                                        columnValue = rs.getDouble(column.name());
                                    } else if (type.equals(Date.class)) {
                                        Timestamp sqlDate = rs.getTimestamp(column.name());
                                        columnValue = new Date(sqlDate.getTime());
                                    } else if (type.equals(Boolean.class)) {
                                        int key = rs.getInt(column.name());
                                        columnValue = key == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                                    } else if (type.equals(String.class)) {
                                        columnValue = rs.getString(column.name());
                                    }
                                }
                                if (columnValue != null) {
                                    writeMethod.invoke((Object)mapper, columnValue);
                                }
                            } else {
                                try {
                                    JsonProperty jp;
                                    Field f = cls.getDeclaredField(property.getName());
                                    Redundant ecf = f.getAnnotation(Redundant.class);
                                    if (ecf != null && (jp = f.getAnnotation(JsonProperty.class)) != null) {
                                        Method writeMethod = property.getWriteMethod();
                                        Object columnValue = null;
                                        String redundantColumnName = jp.value();
                                        if (type.equals(Integer.class)) {
                                            columnValue = rs.getInt(redundantColumnName);
                                        } else if (type.equals(Long.class)) {
                                            columnValue = rs.getLong(redundantColumnName);
                                        } else if (type.equals(Double.class)) {
                                            columnValue = rs.getDouble(redundantColumnName);
                                        } else if (type.equals(Date.class)) {
                                            Timestamp sqlDate = rs.getTimestamp(redundantColumnName);
                                            columnValue = new Date(sqlDate.getTime());
                                        } else if (type.equals(Boolean.class)) {
                                            columnValue = rs.getBoolean(redundantColumnName);
                                        } else if (type.equals(String.class)) {
                                            columnValue = rs.getString(redundantColumnName);
                                        }
                                        if (columnValue != null) {
                                            writeMethod.invoke((Object)mapper, columnValue);
                                        }
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return mapper;
            }
        });
        return list;
    }

    @Override
    public <T extends BusinessObject> List<T> query(T object) throws Exception {
        return this.query(object, false);
    }

    @Override
    public <T extends BusinessObject> List<T> query(T object, Boolean isCascade) throws Exception {
        EMSCriteria criteria = new EMSCriteria();
        this.businessObjectUtils.buildEMSCriteria(true, 0, null, object, criteria);
        List<Object> finalList = new ArrayList();
        Long limit = object.getLimit();
        Long skip = object.getSkip();
        if (limit == null || limit < 0L) {
            limit = Long.MAX_VALUE;
        }
        if (skip == null || skip < 0L) {
            skip = 0L;
        }
        Long total = skip + limit;
        EMSTable table = criteria.getTable();
        for (String tableNameTemp : table.getTableNameList()) {
            if (total == 0L) break;
            StringBuffer sql = new StringBuffer(" select ");
            sql.append(criteria.getSelectSql());
            sql.append(" from ");
            if (!"".equals(table.getSchemaName())) {
                sql.append(String.valueOf(table.getSchemaName()) + "." + tableNameTemp + " ");
            } else {
                sql.append(String.valueOf(tableNameTemp) + " ");
            }
            sql.append("t_0");
            sql.append(criteria.getWhereSql());
            sql.append(criteria.getOrderBySql());
            List<?> list = null;
            try {
                if (this.systemSetting.getSystemPrintSql().booleanValue()) {
                    log.info((Object)("\u67e5\u8be2\u8bed\u53e5\uff1a" + sql));
                    log.info((Object)("\u67e5\u8be2\u53c2\u6570\uff1a" + criteria.getParamList()));
                }
                if (table.getTableNameList().size() == 1) {
                    String string = this.databaseDialect.getPagingSql(sql.toString(), skip, limit);
                    finalList = this.query(string, criteria.getParamList(), object.getClass());
                } else {
                    String string = this.databaseDialect.getPagingSql(sql.toString(), 0L, total);
                    list = this.query(string, criteria.getParamList(), object.getClass());
                }
            }
            catch (Exception exception) {
                this.checkTable(object, table.getSchemaName(), tableNameTemp, exception);
            }
            if (table.getTableNameList().size() <= 1 || list.size() <= 0) continue;
            Long l = skip - (long)list.size();
            if (l >= 0L) {
                skip = l;
            } else if (l < 0L) {
                Long end = null;
                Long start = skip;
                Long remainderInner = total - (long)list.size();
                skip = 0L;
                if (remainderInner >= 0L) {
                    end = new Long(list.size());
                    limit = remainderInner;
                } else {
                    end = total;
                    limit = 0L;
                }
                long idx = start;
                while (idx < end) {
                    finalList.add((BusinessObject)list.get((int)idx));
                    ++idx;
                }
            }
            total = skip + limit;
        }
        if (isCascade != null && isCascade.booleanValue()) {
            String entityName = object.getClass().getAnnotation(Entity.class).name();
            EMSTableAnalysis tableAnalysis = this.analysis.getEntityMap().get(entityName).getTable();
            Map<String, EMSEmbeddedAnalysis> embeddedMap = tableAnalysis.getEmbeddedMap();
            if (embeddedMap != null && embeddedMap.size() > 0) {
                PropertyDescriptor propertyDescriptorId = new PropertyDescriptor(tableAnalysis.getPrimaryKeyProperty(), object.getClass());
                for (BusinessObject businessObject : finalList) {
                    Object value = propertyDescriptorId.getReadMethod().invoke((Object)businessObject, new Object[0]);
                    for (Map.Entry<String, EMSEmbeddedAnalysis> embeddedEntry : embeddedMap.entrySet()) {
                        String propertyName = embeddedEntry.getKey();
                        EMSEmbeddedAnalysis embeddedAnalysis = embeddedEntry.getValue();
                        String embeddedProperty = embeddedAnalysis.getForeignKeyProperty();
                        Class<?> embeddedClass = this.analysis.getEntityMap().get(embeddedAnalysis.getEmbeddedEntity()).getCls();
                        Object embeddedObject = BusinessObjectUtils.getObject(embeddedClass, object.getBuildingForContainer(), object.getSplitTimeType(), object.getSplitEnergyType());
                        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(embeddedProperty, embeddedClass);
                        Method writeMethod = propertyDescriptor.getWriteMethod();
                        writeMethod.invoke(embeddedObject, value);
                        if (embeddedAnalysis.getOrderMap() != null) {
                            for (Map.Entry<String, EMSOrder> entry : embeddedAnalysis.getOrderMap().entrySet()) {
                                ((BusinessObject)embeddedObject).setSort(entry.getKey(), entry.getValue());
                            }
                        }
                        List<?> embeddedList = this.query((T)embeddedObject, true);
                        PropertyDescriptor propertyDescriptorEmbeddedList = new PropertyDescriptor(propertyName, object.getClass());
                        propertyDescriptorEmbeddedList.getWriteMethod().invoke((Object)businessObject, embeddedList);
                    }
                }
            }
        }
        return finalList;
    }

    @Override
    public <T extends BusinessObject> int save(T object) throws Exception {
        EMSInsert insert = new EMSInsert();
        this.businessObjectUtils.buildEMSInsert(object, insert);
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ");
        if (!"".equals(insert.getSchema())) {
            sql.append(String.valueOf(insert.getSchema()) + "." + insert.getTable());
        } else {
            sql.append(insert.getTable());
        }
        sql.append(insert.getInsertIntoSql());
        sql.append(" values ");
        sql.append(insert.getValuesSql());
        int count = 0;
        try {
            if (this.systemSetting.getSystemPrintSql().booleanValue()) {
                log.info((Object)("\u67e5\u8be2\u8bed\u53e5\uff1a" + sql));
                log.info((Object)("\u67e5\u8be2\u53c2\u6570\uff1a" + insert.getParamList()));
            }
            count = this.executeUpdate(sql.toString(), insert.getParamList());
        }
        catch (Exception e) {
            this.checkTable(object, insert.getSchema(), insert.getTable(), e);
            count = this.executeUpdate(sql.toString(), insert.getParamList());
        }
        return count;
    }

    @Override
    public <T extends BusinessObject> int remove(T object) throws Exception {
        return this.remove(object, false);
    }

    @Override
    public <T extends BusinessObject> int update(T objectCriteria, T objectUpdate) throws Exception {
        if (objectCriteria.getClass() != objectUpdate.getClass()) {
            throw new RuntimeException(" \u67e5\u8be2\u5bf9\u8c61\u4e0e\u66f4\u65b0\u5bf9\u8c61\u4e0d\u4e00\u81f4\uff01");
        }
        EMSCriteria criteria = new EMSCriteria();
        this.businessObjectUtils.buildEMSCriteria(false, 0, null, objectCriteria, criteria);
        EMSUpdate update = new EMSUpdate();
        this.businessObjectUtils.buildEMSUpdate(objectUpdate, update);
        EMSTable table = criteria.getTable();
        int count = 0;
        for (String tableNameTemp : table.getTableNameList()) {
            String sql = !"".equals(table.getSchemaName()) ? " update " + table.getSchemaName() + "." + tableNameTemp + " " + update.getSetSql() + criteria.getWhereSql() : " update " + tableNameTemp + " " + update.getSetSql() + criteria.getWhereSql();
            ArrayList<Object> args = new ArrayList<Object>();
            args.addAll(update.getParamList());
            args.addAll(criteria.getParamList());
            try {
                if (this.systemSetting.getSystemPrintSql().booleanValue()) {
                    log.info((Object)("\u67e5\u8be2\u8bed\u53e5\uff1a" + sql));
                    log.info((Object)("\u67e5\u8be2\u53c2\u6570\uff1a" + args));
                }
                count += this.executeUpdate(sql, args);
            }
            catch (Exception e) {
                this.checkTable(objectUpdate, table.getSchemaName(), tableNameTemp, e);
            }
        }
        return count;
    }

    @Override
    public int count(String sql, List<Object> args) throws Exception {
        Integer count = (Integer)this.jdbcTemplate.queryForObject(sql, args.toArray(), Integer.class);
        return count;
    }

    @Override
    public <T extends BusinessObject> int count(T object) throws Exception {
        EMSCriteria criteria = new EMSCriteria();
        this.businessObjectUtils.buildEMSCriteria(false, 0, null, object, criteria);
        EMSTable table = criteria.getTable();
        int count = 0;
        for (String tableNameTemp : table.getTableNameList()) {
            String sql = !"".equals(table.getSchemaName()) ? " select count(*) from " + table.getSchemaName() + "." + tableNameTemp + " " + criteria.getWhereSql() : " select count(*) from " + tableNameTemp + " " + criteria.getWhereSql();
            try {
                if (this.systemSetting.getSystemPrintSql().booleanValue()) {
                    log.info((Object)("\u67e5\u8be2\u8bed\u53e5\uff1a" + sql));
                    log.info((Object)("\u67e5\u8be2\u53c2\u6570\uff1a" + criteria.getParamList()));
                }
                count += this.count(sql, criteria.getParamList());
            }
            catch (Exception e) {
                this.checkTable(object, table.getSchemaName(), tableNameTemp, e);
            }
        }
        return count;
    }

    @Override
    public <T extends BusinessObject> int remove(T object, Boolean isCascade) throws Exception {
        int count = 0;
        String entityName = object.getClass().getAnnotation(Entity.class).name();
        EMSTableAnalysis tableAnalysis = this.analysis.getEntityMap().get(entityName).getTable();
        Map<String, EMSEmbeddedAnalysis> embeddedMap = tableAnalysis.getEmbeddedMap();
        if (isCascade != null && isCascade.booleanValue() && embeddedMap != null && embeddedMap.size() > 0) {
            PropertyDescriptor propertyDescriptorId = new PropertyDescriptor(tableAnalysis.getPrimaryKeyProperty(), object.getClass());
            List<Object> removelist = this.query(object);
            ArrayList<Object> valueList = new ArrayList<Object>();
            for (BusinessObject businessObject : removelist) {
                valueList.add(propertyDescriptorId.getReadMethod().invoke((Object)businessObject, new Object[0]));
            }
            if (valueList.size() > 0) {
                for (Map.Entry entry : embeddedMap.entrySet()) {
                    EMSEmbeddedAnalysis embeddedAnalysis = (EMSEmbeddedAnalysis)entry.getValue();
                    String embeddedProperty = embeddedAnalysis.getForeignKeyProperty();
                    Class<?> embeddedClass = this.analysis.getEntityMap().get(embeddedAnalysis.getEmbeddedEntity()).getCls();
                    Object embeddedObject = BusinessObjectUtils.getObject(embeddedClass, ((BusinessObject)object).getBuildingForContainer(), ((BusinessObject)object).getSplitTimeType(), ((BusinessObject)object).getSplitEnergyType());
                    ((BusinessObject)embeddedObject).setSpecialOperation(embeddedProperty, SpecialOperator.$in, valueList);
                    this.remove((T)embeddedObject, true);
                }
                object = BusinessObjectUtils.getObject(object.getClass(), ((BusinessObject)object).getBuildingForContainer(), ((BusinessObject)object).getSplitTimeType(), ((BusinessObject)object).getSplitEnergyType());
                ((BusinessObject)object).setSpecialOperation(tableAnalysis.getPrimaryKeyProperty(), SpecialOperator.$in, valueList);
            }
        }
        EMSCriteria criteria = new EMSCriteria();
        this.businessObjectUtils.buildEMSCriteria(false, 0, null, object, criteria);
        EMSTable table = criteria.getTable();
        for (String tableNameTemp : table.getTableNameList()) {
            StringBuffer sql = new StringBuffer(" delete from ");
            if (!"".equals(table.getSchemaName())) {
                sql.append(String.valueOf(table.getSchemaName()) + "." + tableNameTemp);
            } else {
                sql.append(tableNameTemp);
            }
            sql.append(criteria.getWhereSql());
            try {
                if (this.systemSetting.getSystemPrintSql().booleanValue()) {
                    log.info((Object)("\u67e5\u8be2\u8bed\u53e5\uff1a" + sql));
                    log.info((Object)("\u67e5\u8be2\u53c2\u6570\uff1a" + criteria.getParamList()));
                }
                count += this.executeUpdate(sql.toString(), criteria.getParamList());
            }
            catch (Exception e) {
                this.checkTable(object, table.getSchemaName(), tableNameTemp, e);
            }
        }
        return count;
    }

    private <T extends BusinessObject> void checkTable(T object, String schemaName, String tableName, Exception e) throws Exception {
        if (this.databaseDialect.isTableNotExists(e).booleanValue()) {
            if (!"".equals(schemaName)) {
                log.info((Object)("\u5efa\u8868\uff1a" + schemaName + "." + tableName));
            } else {
                log.info((Object)("\u5efa\u8868\uff1a" + tableName));
            }
            List<String> createTableSqlList = this.databaseDialect.getCreateTableSql(object.getClass());
            for (String createTableSql : createTableSqlList) {
                String realSql = BusinessObjectUtils.createTableSqlReplace(createTableSql, schemaName, tableName);
                this.executeUpdate(realSql, null);
            }
        } else {
            throw e;
        }
    }

    @Override
    public int[] batchUpdate(String sql, List<Object[]> batchArgs) throws Exception {
        return this.jdbcTemplate.batchUpdate(sql, batchArgs);
    }
}

