/*
 * Decompiled with CFR 0.152.
 */
package com.persagy.core.mvc.dialect;

import com.persagy.core.annotation.Entity;
import com.persagy.core.annotation.Table;
import com.persagy.core.constant.SchemaConstant;
import com.persagy.core.dto.analysis.EMSAnalysis;
import com.persagy.core.mvc.dialect.DatabaseDialect;
import com.persagy.core.mvc.pojo.BusinessObject;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

public abstract class BaseDatabaseDialect
implements DatabaseDialect {
    protected Map<String, List<String>> tableMap = new HashMap<String, List<String>>();
    @Resource
    protected EMSAnalysis analysis;

    @Override
    public <T extends BusinessObject> List<String> getCreateTableSql(Class<T> cls) {
        Entity entity = cls.getAnnotation(Entity.class);
        String entityName = entity.name();
        return this.tableMap.get(entityName);
    }

    @Override
    public String getRealSchema(Class<?> cls) {
        Table table = cls.getAnnotation(Table.class);
        String schema = table.schema() != SchemaConstant.Schema.NONE ? SchemaConstant.getSchema(table.schema().getValue()) : "";
        return schema;
    }

    @Override
    public Boolean isTableNotExists(Exception exception) {
        Throwable throwable = exception.getCause();
        if (!(throwable instanceof SQLException)) {
            return false;
        }
        SQLException se = (SQLException)throwable;
        String errorCode = new Integer(se.getErrorCode()).toString();
        if (this.getTableNotExistCode().equalsIgnoreCase(errorCode)) {
            return true;
        }
        return false;
    }
}

