/*
 * Decompiled with CFR 0.152.
 */
package com.persagy.core.mvc.dialect.impl.sqlserver;

import com.persagy.core.dto.analysis.EMSColumnAnalysis;
import com.persagy.core.dto.analysis.EMSEntityAnalysis;
import com.persagy.core.dto.analysis.EMSIndexAnalysis;
import com.persagy.core.dto.analysis.EMSTableAnalysis;
import com.persagy.core.mvc.dialect.BaseDatabaseDialect;
import com.persagy.core.mvc.dialect.DatabaseDialect;
import com.persagy.core.utils.CommonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component(value="com.microsoft.sqlserver.jdbc.SQLServerDriver")
public class SqlServerDialect
extends BaseDatabaseDialect
implements DatabaseDialect {
    private static Logger log = Logger.getLogger(SqlServerDialect.class);

    @Override
    public String getPagingSql(String noPagingSql, Long skip, Long limit) {
        if (skip == null || skip < 0L) {
            skip = 0L;
        }
        StringBuffer sql = new StringBuffer();
        int selectIdx = noPagingSql.indexOf("select");
        String selectStr = noPagingSql.substring(0, selectIdx + 6);
        String otherStr = noPagingSql.substring(selectIdx + 6);
        if (skip == 0L) {
            sql.append(selectStr);
            sql.append(" top " + limit + " ");
            sql.append(otherStr);
        } else {
            int orderByIdx = otherStr.indexOf("order by");
            if (orderByIdx == -1) {
                throw new RuntimeException(" The sql is marked paging, so it must have order by clause. ");
            }
            String middleStr = otherStr.substring(0, orderByIdx);
            String orderByStr = otherStr.substring(orderByIdx);
            sql.append(" select * from (");
            sql.append(selectStr);
            sql.append(" ROW_NUMBER() OVER (" + orderByStr + ") as ems_rownum , ");
            sql.append(middleStr);
            sql.append(") ems where ems.ems_rownum between " + (skip + 1L) + " and " + (skip + limit));
        }
        return sql.toString();
    }

    @Override
    public List<String> getCreateSchemaSql(String schemaName) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("create database " + schemaName);
        return list;
    }

    @Override
    public String getTableInfoSql() {
        return "select name table_schema from master.dbo.sysdatabases";
    }

    @Override
    public String getRealSchema(Class<?> cls) {
        return String.valueOf(super.getRealSchema(cls)) + "." + "dbo";
    }

    @Override
    public String getTableNotExistCode() {
        return "208";
    }

    @Override
    public String getSchemaExistSql(String schemaName) {
        return "select * from sys.databases where name = '" + schemaName + "'";
    }

    @Override
    public String getDatabaseColumnType(Class<?> cls, Integer length, Integer scale) {
        String columnType = null;
        if (cls == String.class) {
            columnType = "nvarchar";
        } else if (cls == Long.class || cls == Integer.class || cls == Boolean.class) {
            columnType = "int";
        } else if (cls == Double.class) {
            columnType = "decimal";
        } else if (cls == Date.class) {
            columnType = "datetime2";
        } else {
            throw new RuntimeException("\u5bf9\u8c61\u5b57\u6bb5\u7c7b\u578b\u4e0d\u652f\u6301" + cls);
        }
        return columnType;
    }

    @Override
    public void init() throws Exception {
        log.info((Object)"******** SqlServer\u914d\u7f6e\u521d\u59cb\u5316\u5f00\u59cb ********");
        HashMap<String, Object> root = new HashMap<String, Object>();
        for (Map.Entry<String, EMSEntityAnalysis> entityEntry : this.analysis.getEntityMap().entrySet()) {
            String entityKey = entityEntry.getKey();
            EMSEntityAnalysis entity = entityEntry.getValue();
            EMSTableAnalysis table = entity.getTable();
            ArrayList<EMSColumnAnalysis> columnList = new ArrayList<EMSColumnAnalysis>();
            for (Map.Entry<String, EMSColumnAnalysis> columnEntry : table.getColumnMap().entrySet()) {
                EMSColumnAnalysis column = new EMSColumnAnalysis();
                BeanUtils.copyProperties((Object)columnEntry.getValue(), (Object)column);
                if (column.getType().equals("datetime2")) {
                    column.setLength(7);
                    column.setScale(0);
                }
                if (column.getType().equals("int")) {
                    column.setLength(0);
                }
                if (column.getType().equals("nvarchar") && column.getLength() > 4000) {
                    column.setLength(4000);
                }
                columnList.add(column);
            }
            Collections.sort(columnList);
            root.put("columnList", columnList);
            root.put("primaryKey", table.getPrimaryKey());
            ArrayList<String> ddlList = (ArrayList<String>)this.tableMap.get(entityKey);
            if (ddlList == null) {
                ddlList = new ArrayList<String>();
                this.tableMap.put(entityKey, ddlList);
            }
            String tableCreateSql = CommonUtils.getSqlByTemplate(root, "TableCreate.ftl");
            ddlList.add(tableCreateSql);
            root.clear();
            for (EMSIndexAnalysis index : table.getIndexList()) {
                root.put("index", index);
                ddlList.add(CommonUtils.getSqlByTemplate(root, "IndexCreate.ftl"));
            }
        }
        log.info((Object)"******** SqlServer\u914d\u7f6e\u521d\u59cb\u5316\u7ed3\u675f ********");
    }
}

