/*
 * Decompiled with CFR 0.152.
 */
package com.persagy.core.mvc.pojo;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.persagy.core.annotation.Dimension;
import com.persagy.core.annotation.Property;
import com.persagy.core.constant.SystemConstant;
import com.persagy.core.enumeration.EMSDimension;
import com.persagy.core.enumeration.EMSOrder;
import com.persagy.core.enumeration.SpecialOperator;
import com.persagy.core.mvc.pojo.SpecialOperation;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public abstract class BusinessObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long skip;
    private Long limit;
    private String buildingForContainer;
    private Integer splitTimeType;
    private Integer splitEnergyType;
    private Map<String, List<SpecialOperation>> specialOperateMap = new LinkedHashMap<String, List<SpecialOperation>>();
    private Map<String, EMSOrder> sortMap = new LinkedHashMap<String, EMSOrder>();
    private Map<String, String> extensionMap = new LinkedHashMap<String, String>();

    public void setSpecialOperateMap(Map<String, List<SpecialOperation>> specialOperateMap) {
        this.specialOperateMap = specialOperateMap;
    }

    public void setSortMap(Map<String, EMSOrder> sortMap) {
        this.sortMap = sortMap;
    }

    public void setExtensionMap(Map<String, String> extensionMap) {
        this.extensionMap = extensionMap;
    }

    public Long getSkip() {
        return this.skip;
    }

    public void setSkip(Long skip) {
        this.skip = skip;
    }

    public Long getLimit() {
        return this.limit;
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public Map<String, EMSOrder> getSortMap() {
        return this.sortMap;
    }

    public Integer getSplitTimeType() {
        return this.splitTimeType;
    }

    public void setSplitTimeType(Integer splitTimeType) {
        this.splitTimeType = splitTimeType;
    }

    public Integer getSplitEnergyType() {
        return this.splitEnergyType;
    }

    public void setSplitEnergyType(Integer splitEnergyType) {
        this.splitEnergyType = splitEnergyType;
    }

    public void setBuildingForContainer(String buildingForContainer) {
        if (buildingForContainer != null) {
            buildingForContainer = buildingForContainer.toLowerCase();
        }
        this.buildingForContainer = buildingForContainer;
    }

    public String getBuildingForContainer() {
        return this.buildingForContainer;
    }

    public Map<String, List<SpecialOperation>> getSpecialOperateMap() {
        return this.specialOperateMap;
    }

    public Map<String, String> getExtensionMap() throws Exception {
        if (this.extensionMap.size() == 0) {
            PropertyDescriptor[] propertyList;
            Class<?> cls = this.getClass();
            BeanInfo bi = Introspector.getBeanInfo(cls);
            PropertyDescriptor[] propertyDescriptorArray = propertyList = bi.getPropertyDescriptors();
            int n = propertyList.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor property = propertyDescriptorArray[n2];
                String propertyName = property.getName();
                Method readMethod = property.getReadMethod();
                try {
                    Field field = cls.getDeclaredField(propertyName);
                    Property propertyAnnotation = field.getAnnotation(Property.class);
                    if (propertyAnnotation != null) {
                        List list = (List)readMethod.invoke((Object)this, new Object[0]);
                        if (list == null || list.size() == 0) break;
                        for (BusinessObject propertyObject : list) {
                            PropertyDescriptor propertyNameProperty = new PropertyDescriptor(propertyAnnotation.propertyNameField(), propertyObject.getClass());
                            PropertyDescriptor propertyValueProperty = new PropertyDescriptor(propertyAnnotation.propertyValueField(), propertyObject.getClass());
                            Method readMethodName = propertyNameProperty.getReadMethod();
                            Method readMethodValue = propertyValueProperty.getReadMethod();
                            String propertyNameValue = (String)readMethodName.invoke((Object)propertyObject, new Object[0]);
                            String propertyValueValue = (String)readMethodValue.invoke((Object)propertyObject, new Object[0]);
                            this.extensionMap.put(propertyNameValue, propertyValueValue);
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
        return this.extensionMap;
    }

    public void setSort(String fieldName, EMSOrder order) {
        Boolean isFind = false;
        try {
            PropertyDescriptor[] propertyList;
            BeanInfo bi = Introspector.getBeanInfo(this.getClass());
            PropertyDescriptor[] propertyDescriptorArray = propertyList = bi.getPropertyDescriptors();
            int n = propertyList.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
                String realFieldName = propertyDescriptor.getName();
                if (realFieldName.equalsIgnoreCase(fieldName)) {
                    fieldName = realFieldName;
                    isFind = true;
                }
                ++n2;
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e.getMessage());
        }
        if (!isFind.booleanValue()) {
            return;
        }
        this.sortMap.put(fieldName, order);
    }

    public void setSpecialOperation(String fieldName, SpecialOperator operator, Object value) {
        Boolean isFind = false;
        try {
            PropertyDescriptor[] propertyList;
            BeanInfo bi = Introspector.getBeanInfo(this.getClass());
            PropertyDescriptor[] propertyDescriptorArray = propertyList = bi.getPropertyDescriptors();
            int n = propertyList.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
                String realFieldName = propertyDescriptor.getName();
                if (realFieldName.equalsIgnoreCase(fieldName)) {
                    fieldName = realFieldName;
                    isFind = true;
                }
                ++n2;
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e.getMessage());
        }
        if (!isFind.booleanValue()) {
            return;
        }
        List<SpecialOperation> list = this.specialOperateMap.get(fieldName);
        if (list == null) {
            list = new ArrayList<SpecialOperation>();
            this.specialOperateMap.put(fieldName, list);
        }
        SpecialOperation operation = new SpecialOperation();
        operation.setSpecialOperator(operator);
        operation.setValue(value);
        list.add(operation);
    }

    public final Boolean check() {
        Boolean flag = true;
        Class<?> cls = this.getClass();
        Dimension emsDimension = cls.getAnnotation(Dimension.class);
        if (emsDimension != null) {
            EMSDimension dimension = emsDimension.dimension();
            if (dimension == EMSDimension.Building) {
                if (this.buildingForContainer == null || "".equals(this.buildingForContainer) || this.splitTimeType != null || this.splitEnergyType != null) {
                    flag = false;
                }
            } else if (dimension == EMSDimension.BuildingEnergyTime) {
                if (this.buildingForContainer == null || "".equals(this.buildingForContainer) || this.splitTimeType == null || this.splitEnergyType == null) {
                    flag = false;
                }
            } else if (dimension == EMSDimension.BuildingTime) {
                if (this.buildingForContainer == null || "".equals(this.buildingForContainer) || this.splitTimeType == null || this.splitEnergyType != null) {
                    flag = false;
                }
            } else if (dimension == EMSDimension.No && (this.buildingForContainer != null && !"".equals(this.buildingForContainer) || this.splitTimeType != null || this.splitEnergyType != null)) {
                flag = false;
            }
        } else {
            flag = false;
        }
        return flag;
    }

    public String buildId() {
        return UUID.randomUUID().toString();
    }

    public void setNull(Set<String> fieldSet) throws Exception {
        PropertyDescriptor[] propertyList;
        if (fieldSet == null) {
            return;
        }
        BeanInfo bi = Introspector.getBeanInfo(this.getClass(), BusinessObject.class);
        PropertyDescriptor[] propertyDescriptorArray = propertyList = bi.getPropertyDescriptors();
        int n = propertyList.length;
        int n2 = 0;
        while (n2 < n) {
            Object value;
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
            String propertyName = propertyDescriptor.getName();
            if ((fieldSet.size() == 0 || fieldSet.contains(propertyName)) && (value = propertyDescriptor.getReadMethod().invoke((Object)this, new Object[0])) == null) {
                this.setSpecialOperation(propertyName, SpecialOperator.$exists, false);
            }
            ++n2;
        }
    }

    public String toString() {
        String objectString = null;
        try {
            objectString = SystemConstant.jsonMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return objectString;
    }
}

