/*
 * Decompiled with CFR 0.152.
 */
package com.persagy.core.utils;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.persagy.core.annotation.Dimension;
import com.persagy.core.annotation.Entity;
import com.persagy.core.annotation.Table;
import com.persagy.core.constant.EMSConstant;
import com.persagy.core.constant.SystemSetting;
import com.persagy.core.dto.analysis.EMSAnalysis;
import com.persagy.core.dto.analysis.EMSColumnAnalysis;
import com.persagy.core.dto.analysis.EMSEmbeddedAnalysis;
import com.persagy.core.dto.analysis.EMSEntityAnalysis;
import com.persagy.core.dto.analysis.EMSRedundantAnalysis;
import com.persagy.core.dto.analysis.EMSTableAnalysis;
import com.persagy.core.dto.build.EMSCriteria;
import com.persagy.core.dto.build.EMSInsert;
import com.persagy.core.dto.build.EMSMonthRange;
import com.persagy.core.dto.build.EMSUpdate;
import com.persagy.core.enumeration.EMSDimension;
import com.persagy.core.enumeration.EMSOrder;
import com.persagy.core.enumeration.SpecialOperator;
import com.persagy.core.mvc.pojo.BusinessObject;
import com.persagy.core.mvc.pojo.SpecialOperation;
import com.persagy.core.thread.EmsMonthThread;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Resource;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Component;

@Component
public class BusinessObjectUtils {
    public static final String prefix = "t";
    public static final String redundantPrefix = "r";
    public static final String subPrefix = "s";
    private static final Random random = new Random();
    @Resource
    private SystemSetting systemSetting;
    @Resource
    private EMSAnalysis analysis;

    /*
     * WARNING - void declaration
     */
    public <T extends BusinessObject> void buildEMSCriteria(Boolean isSelect, Integer level, Integer embeddedIdx, T object, EMSCriteria criteria) throws Exception {
        Object propertyName;
        Boolean isPrefix;
        if (object == null) {
            throw new Exception("\u67e5\u8be2\u5bf9\u8c61\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!object.check().booleanValue()) {
            throw new Exception("\u67e5\u8be2\u5bf9\u8c61\u6a21\u677f\u4e0d\u80fd\u4e3a\u9644\u52a0\u7ed3\u6784\u9519\u8bef\uff01");
        }
        if (level == null || level < 0) {
            level = 0;
        }
        if (isSelect == null) {
            isSelect = true;
        }
        String prefixTemp = (isPrefix = level == 0 && isSelect == false ? Boolean.valueOf(false) : Boolean.valueOf(true)).booleanValue() ? (level == 0 ? "t_" + level + "." : "s_" + level + "_" + embeddedIdx + ".") : "";
        StringBuffer selectSql = criteria.getSelectSql();
        StringBuffer whereSql = criteria.getWhereSql();
        whereSql.append(" where 1=1 ");
        StringBuffer orderBySql = criteria.getOrderBySql();
        List<Object> paramList = criteria.getParamList();
        StringBuffer subquerySql = new StringBuffer();
        ArrayList<Object> subqueryParamList = new ArrayList<Object>();
        Class<?> cls = object.getClass();
        Entity entity = cls.getAnnotation(Entity.class);
        EMSEntityAnalysis entityAnalysis = this.analysis.getEntityMap().get(entity.name());
        EMSTableAnalysis tableAnalysis = entityAnalysis.getTable();
        Map<String, EMSColumnAnalysis> columnMap = tableAnalysis.getColumnMap();
        Map<String, EMSRedundantAnalysis> redundantMap = tableAnalysis.getRedundantMap();
        Map<String, EMSEmbeddedAnalysis> embeddedMap = tableAnalysis.getEmbeddedMap();
        boolean isDesc = false;
        boolean isSplit = false;
        EMSMonthRange monthRange = new EMSMonthRange();
        if (level == 0) {
            criteria.getTable().setSchemaName(tableAnalysis.getSchema());
            if (tableAnalysis.getMonth() != null && !"".equals(tableAnalysis.getMonth()) && this.systemSetting.getJdbcDriverClass().equals("com.mysql.jdbc.Driver")) {
                isSplit = true;
                monthRange.setEqualList(new ArrayList<Date>());
            }
            boolean isFirst = true;
            for (Map.Entry<String, EMSOrder> entry : object.getSortMap().entrySet()) {
                propertyName = entry.getKey();
                EMSColumnAnalysis columnAnalysis = columnMap.get(propertyName);
                if (columnAnalysis == null) continue;
                EMSOrder ascDesc = entry.getValue();
                if (ascDesc == EMSOrder.Desc && isSplit) {
                    isDesc = true;
                }
                if (isFirst) {
                    orderBySql.append(" order by ");
                } else {
                    orderBySql.append(",");
                }
                orderBySql.append(String.valueOf(prefixTemp) + columnAnalysis.getName() + " " + ascDesc.name());
                isFirst = false;
            }
            boolean bl = false;
            if (isSelect.booleanValue()) {
                selectSql.append(" " + prefixTemp + "* ");
            }
            for (Map.Entry entry : redundantMap.entrySet()) {
                void var25_36;
                String propertyName2 = (String)entry.getKey();
                EMSRedundantAnalysis redundantAnalysis = (EMSRedundantAnalysis)entry.getValue();
                String mainEntity = redundantAnalysis.getMainEntity();
                EMSEntityAnalysis redundantEntityAnalysis = this.analysis.getEntityMap().get(mainEntity);
                String redundantTableName = BusinessObjectUtils.getTableName(BusinessObjectUtils.getObject(redundantEntityAnalysis.getCls(), object.getBuildingForContainer(), object.getSplitTimeType(), object.getSplitEnergyType()));
                String valueColumn = redundantAnalysis.getValueColumn();
                String foreignColumn = redundantAnalysis.getForeignColumn();
                String redundantName = redundantAnalysis.getRedundantName();
                String redundantPrefixTemp = redundantPrefix + (int)var25_36;
                if (isSelect.booleanValue()) {
                    selectSql.append(",(select ");
                    selectSql.append(String.valueOf(redundantPrefixTemp) + "." + valueColumn);
                    selectSql.append(" from ");
                    if (!"".equals(redundantEntityAnalysis.getTable().getSchema())) {
                        selectSql.append(String.valueOf(redundantEntityAnalysis.getTable().getSchema()) + "." + redundantTableName + " " + redundantPrefixTemp);
                    } else {
                        selectSql.append(String.valueOf(redundantTableName) + " " + redundantPrefixTemp);
                    }
                    selectSql.append(" where ");
                    selectSql.append(String.valueOf(redundantPrefixTemp) + "." + redundantEntityAnalysis.getTable().getPrimaryKey());
                    selectSql.append(" = ");
                    selectSql.append(String.valueOf(prefixTemp) + foreignColumn);
                    selectSql.append(") ");
                    selectSql.append(redundantName);
                }
                StringBuffer subquerySqlTemp = new StringBuffer();
                this.buildWhereSql(subquerySqlTemp, subqueryParamList, isSplit, object, propertyName2, "", null);
                if (subquerySqlTemp.length() > 0) {
                    String subPrefixTemp = "r_" + (level + 1) + "_" + (int)var25_36;
                    subquerySql.append(" and " + prefixTemp + foreignColumn + " in ( ");
                    subquerySql.append(" select ");
                    subquerySql.append(String.valueOf(subPrefixTemp) + "." + redundantEntityAnalysis.getTable().getPrimaryKey());
                    subquerySql.append(" from ");
                    if (!"".equals(redundantEntityAnalysis.getTable().getSchema())) {
                        subquerySql.append(String.valueOf(redundantEntityAnalysis.getTable().getSchema()) + "." + redundantTableName + " " + subPrefixTemp);
                    } else {
                        subquerySql.append(String.valueOf(redundantTableName) + " " + subPrefixTemp);
                    }
                    subquerySql.append(" where " + subPrefixTemp + "." + valueColumn + " ");
                    subquerySql.append(subquerySqlTemp);
                    subquerySql.append(" )");
                }
                ++var25_36;
            }
        }
        for (Map.Entry<String, EMSColumnAnalysis> columnEntry : columnMap.entrySet()) {
            String string = columnEntry.getKey();
            EMSColumnAnalysis columnAnalysis = columnEntry.getValue();
            this.buildWhereSql(whereSql, paramList, isSplit, object, string, " and " + prefixTemp + columnAnalysis.getName(), monthRange);
        }
        int embeddedIdxTemp = 0;
        for (Map.Entry<String, EMSEmbeddedAnalysis> entry : embeddedMap.entrySet()) {
            propertyName = entry.getKey();
            EMSEmbeddedAnalysis embeddedAnalysis = entry.getValue();
            PropertyDescriptor property = new PropertyDescriptor((String)propertyName, object.getClass());
            Method readMethod = property.getReadMethod();
            List list = (List)readMethod.invoke(object, new Object[0]);
            if (list == null || list.size() <= 0) continue;
            String embeddedEntity = embeddedAnalysis.getEmbeddedEntity();
            EMSEntityAnalysis embeddedEntityAnalysis = this.analysis.getEntityMap().get(embeddedEntity);
            String foreignKey = embeddedAnalysis.getForeignKey();
            String embeddedTableName = BusinessObjectUtils.getTableName(BusinessObjectUtils.getObject(embeddedEntityAnalysis.getCls(), object.getBuildingForContainer(), object.getSplitTimeType(), object.getSplitEnergyType()));
            String subPrefixTemp = "s_" + (level + 1) + "_" + embeddedIdxTemp;
            whereSql.append(" and " + prefixTemp + tableAnalysis.getPrimaryKey() + " in ( ");
            whereSql.append(" select ");
            whereSql.append(String.valueOf(subPrefixTemp) + "." + foreignKey);
            whereSql.append(" from ");
            if (!"".equals(embeddedEntityAnalysis.getTable().getSchema())) {
                whereSql.append(String.valueOf(embeddedEntityAnalysis.getTable().getSchema()) + "." + embeddedTableName + " " + subPrefixTemp);
            } else {
                whereSql.append(String.valueOf(embeddedTableName) + " " + subPrefixTemp);
            }
            this.buildEMSCriteria(isSelect, level + 1, embeddedIdxTemp, (BusinessObject)list.get(0), criteria);
            subquerySql.append(" )");
            ++embeddedIdxTemp;
        }
        whereSql.append(subquerySql);
        paramList.addAll(subqueryParamList);
        String string = BusinessObjectUtils.getTableName(object);
        List<String> list = criteria.getTable().getTableNameList();
        if (level == 0) {
            if (isSplit) {
                list.addAll(EmsMonthThread.getTableList(string));
                if (isDesc) {
                    Collections.reverse(list);
                }
                BusinessObjectUtils.skip(list, monthRange);
            } else {
                list.add(string);
            }
        }
    }

    public static Boolean isSkip(Date month, EMSMonthRange monthRange) {
        Boolean flag = false;
        if (monthRange.getEqualList() != null && monthRange.getEqualList().size() > 0) {
            for (Date dateEqual : monthRange.getEqualList()) {
                int equalFlag = DateUtils.truncate((Date)dateEqual, (int)2).compareTo(month);
                if (equalFlag == 0) {
                    flag = false;
                    break;
                }
                flag = true;
            }
        } else {
            Date now = new Date();
            if (monthRange.getGreaterDate() == null) {
                monthRange.setGreaterDate(DateUtils.addYears((Date)now, (int)-100));
            }
            if (monthRange.getLessDate() == null) {
                monthRange.setLessDate(DateUtils.addYears((Date)now, (int)100));
            }
            if (monthRange.getGreaterOperator() == null) {
                monthRange.setGreaterOperator(SpecialOperator.$gte);
            }
            if (monthRange.getLessOperator() == null) {
                monthRange.setLessOperator(SpecialOperator.$lte);
            }
            int greaterFlag = month.compareTo(DateUtils.truncate((Date)monthRange.getGreaterDate(), (int)2));
            int lessFlag = month.compareTo(monthRange.getLessDate());
            flag = greaterFlag >= 0 && lessFlag <= 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        return flag;
    }

    public static void skip(List<String> tableList, EMSMonthRange monthRange) throws Exception {
        SimpleDateFormat yyyyMM = new SimpleDateFormat("yyyyMM");
        ArrayList<String> removeList = new ArrayList<String>();
        for (String table : tableList) {
            String source = table.split("_")[0];
            Date month = yyyyMM.parse(source);
            Boolean isSkip = BusinessObjectUtils.isSkip(month, monthRange);
            if (!isSkip.booleanValue()) continue;
            removeList.add(table);
        }
        tableList.removeAll(removeList);
    }

    public static <T extends BusinessObject> String getTableName(T object) {
        String name;
        Class<?> cls = object.getClass();
        Table table = cls.getAnnotation(Table.class);
        String tableName = name = table.name();
        if (object.getBuildingForContainer() != null && !"".equals(object.getBuildingForContainer())) {
            tableName = String.valueOf(tableName) + "_" + object.getBuildingForContainer();
        }
        if (object.getSplitEnergyType() != null) {
            tableName = String.valueOf(tableName) + "_e" + object.getSplitEnergyType();
        }
        if (object.getSplitTimeType() != null) {
            tableName = String.valueOf(tableName) + "_t" + object.getSplitTimeType();
        }
        return tableName;
    }

    public static <T extends BusinessObject> T getObject(Class<T> cls, String building, Integer timeType, Integer energyType) throws Exception {
        BusinessObject businessObject = (BusinessObject)cls.newInstance();
        Dimension dimension = cls.getAnnotation(Dimension.class);
        if (dimension.dimension() == EMSDimension.Building) {
            businessObject.setBuildingForContainer(building);
        } else if (dimension.dimension() == EMSDimension.BuildingTime) {
            businessObject.setBuildingForContainer(building);
            businessObject.setSplitTimeType(timeType);
        } else if (dimension.dimension() == EMSDimension.BuildingEnergyTime) {
            businessObject.setBuildingForContainer(building);
            businessObject.setSplitTimeType(timeType);
            businessObject.setSplitEnergyType(energyType);
        }
        return (T)businessObject;
    }

    private <T extends BusinessObject> void buildWhereSql(StringBuffer whereSql, List<Object> paramList, Boolean isSplit, T object, String propertyName, String column, EMSMonthRange range) throws Exception {
        PropertyDescriptor property = new PropertyDescriptor(propertyName, object.getClass());
        Method readMethod = property.getReadMethod();
        Object value = null;
        Object temp = readMethod.invoke(object, new Object[0]);
        if (temp != null && temp instanceof Date) {
            Timestamp date = new Timestamp(((Date)temp).getTime());
            value = date;
            if (isSplit.booleanValue() && range != null) {
                range.getEqualList().add((Date)temp);
            }
        } else {
            value = temp != null && temp instanceof Boolean ? (((Boolean)temp).booleanValue() ? Integer.valueOf(1) : Integer.valueOf(0)) : temp;
        }
        if (value != null) {
            whereSql.append(String.valueOf(column) + " = ? ");
            paramList.add(value);
        } else {
            List<SpecialOperation> list = object.getSpecialOperateMap().get(property.getName());
            if (list != null && list.size() > 0) {
                for (SpecialOperation operation : list) {
                    SpecialOperator specialOperator = operation.getSpecialOperator();
                    whereSql.append(String.valueOf(column) + specialOperator.getOperator());
                    if (specialOperator == SpecialOperator.$nin || specialOperator == SpecialOperator.$in) {
                        whereSql.append(" (");
                        int idx = 0;
                        List valueList = (List)List.class.cast(operation.getValue());
                        for (Object obj : valueList) {
                            if (obj != null && obj instanceof Date) {
                                Timestamp date = new Timestamp(((Date)obj).getTime());
                                value = date;
                                if (isSplit.booleanValue() && specialOperator == SpecialOperator.$in && range != null) {
                                    range.getEqualList().add((Date)obj);
                                }
                            } else {
                                value = obj != null && obj instanceof Boolean ? (((Boolean)obj).booleanValue() ? Integer.valueOf(1) : Integer.valueOf(0)) : obj;
                            }
                            paramList.add(value);
                            if (idx != 0) {
                                whereSql.append(",");
                            }
                            whereSql.append("?");
                            ++idx;
                        }
                        whereSql.append(") ");
                        continue;
                    }
                    if (specialOperator == SpecialOperator.$null || specialOperator == SpecialOperator.$not_null) continue;
                    if (specialOperator == SpecialOperator.$exists) {
                        if (operation.getValue().equals(true)) {
                            whereSql.append(" not null ");
                            continue;
                        }
                        whereSql.append(" null ");
                        continue;
                    }
                    whereSql.append(" ? ");
                    Object obj = operation.getValue();
                    if (obj != null && obj instanceof Date) {
                        Timestamp date = new Timestamp(((Date)obj).getTime());
                        value = date;
                        if (isSplit.booleanValue()) {
                            if ((specialOperator == SpecialOperator.$gte || specialOperator == SpecialOperator.$gt) && range != null) {
                                range.setGreaterOperator(specialOperator);
                                range.setGreaterDate((Date)obj);
                            }
                            if ((specialOperator == SpecialOperator.$lte || specialOperator == SpecialOperator.$lt) && range != null) {
                                range.setLessOperator(specialOperator);
                                range.setLessDate((Date)obj);
                            }
                        }
                    } else {
                        value = obj != null && obj instanceof Boolean ? (((Boolean)obj).booleanValue() ? Integer.valueOf(1) : Integer.valueOf(0)) : obj;
                    }
                    paramList.add(value);
                }
            }
        }
    }

    public <T extends BusinessObject> void buildEMSUpdate(T object, EMSUpdate update) throws Exception {
        if (object == null) {
            throw new Exception("\u67e5\u8be2\u5bf9\u8c61\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!object.check().booleanValue()) {
            throw new Exception("\u67e5\u8be2\u5bf9\u8c61\u6a21\u677f\u4e0d\u80fd\u4e3a\u9644\u52a0\u7ed3\u6784\u9519\u8bef\uff01");
        }
        StringBuffer setSql = update.getSetSql();
        setSql.append(" set ");
        List<Object> paramList = update.getParamList();
        Class<?> cls = object.getClass();
        Entity entity = cls.getAnnotation(Entity.class);
        EMSEntityAnalysis entityAnalysis = this.analysis.getEntityMap().get(entity.name());
        EMSTableAnalysis tableAnalysis = entityAnalysis.getTable();
        Map<String, EMSColumnAnalysis> columnMap = tableAnalysis.getColumnMap();
        boolean isSplit = false;
        EMSMonthRange monthRange = new EMSMonthRange();
        if (tableAnalysis.getMonth() != null && !"".equals(tableAnalysis.getMonth()) && this.systemSetting.getJdbcDriverClass().equals("com.mysql.jdbc.Driver")) {
            isSplit = true;
            monthRange.setEqualList(new ArrayList<Date>());
        }
        int mark = 0;
        for (Map.Entry<String, EMSColumnAnalysis> columnEntry : columnMap.entrySet()) {
            String propertyName = columnEntry.getKey();
            EMSColumnAnalysis columnAnalysis = columnEntry.getValue();
            PropertyDescriptor property = new PropertyDescriptor(propertyName, object.getClass());
            Method readMethod = property.getReadMethod();
            Object value = null;
            Object temp = readMethod.invoke(object, new Object[0]);
            if (temp != null && temp instanceof Date) {
                Timestamp date = new Timestamp(((Date)temp).getTime());
                value = date;
            } else {
                value = temp != null && temp instanceof Boolean ? (((Boolean)temp).booleanValue() ? Integer.valueOf(1) : Integer.valueOf(0)) : temp;
            }
            if (value != null) {
                if (mark != 0) {
                    setSql.append(" , ");
                }
                setSql.append(String.valueOf(columnAnalysis.getName()) + " = ? ");
                paramList.add(value);
                ++mark;
                continue;
            }
            List<SpecialOperation> list = object.getSpecialOperateMap().get(property.getName());
            if (list == null || list.size() <= 0) continue;
            for (SpecialOperation operation : list) {
                SpecialOperator specialOperator = operation.getSpecialOperator();
                if (specialOperator != SpecialOperator.$null && (specialOperator != SpecialOperator.$exists || !operation.getValue().equals(false))) continue;
                if (mark != 0) {
                    setSql.append(" , ");
                }
                setSql.append(String.valueOf(columnAnalysis.getName()) + " = null ");
                ++mark;
            }
        }
        String tableName = BusinessObjectUtils.getTableName(object);
        List<String> tableList = update.getTable().getTableNameList();
        if (isSplit) {
            tableList.addAll(EmsMonthThread.getTableList(tableName));
            BusinessObjectUtils.skip(tableList, monthRange);
        } else {
            tableList.add(tableName);
        }
    }

    public <T extends BusinessObject> void buildEMSInsert(T object, EMSInsert insert) throws Exception {
        if (object == null) {
            throw new Exception("\u67e5\u8be2\u5bf9\u8c61\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!object.check().booleanValue()) {
            throw new Exception("\u67e5\u8be2\u5bf9\u8c61\u6a21\u677f\u4e0d\u80fd\u4e3a\u9644\u52a0\u7ed3\u6784\u9519\u8bef\uff01");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        String month = null;
        List<Object> paramList = insert.getParamList();
        StringBuffer insertIntoSql = insert.getInsertIntoSql();
        StringBuffer valuesSql = insert.getValuesSql();
        Class<?> cls = object.getClass();
        Entity entity = cls.getAnnotation(Entity.class);
        EMSEntityAnalysis entityAnalysis = this.analysis.getEntityMap().get(entity.name());
        EMSTableAnalysis tableAnalysis = entityAnalysis.getTable();
        Map<String, EMSColumnAnalysis> columnMap = tableAnalysis.getColumnMap();
        boolean isSplit = false;
        if (tableAnalysis.getMonth() != null && !"".equals(tableAnalysis.getMonth()) && this.systemSetting.getJdbcDriverClass().equals("com.mysql.jdbc.Driver")) {
            isSplit = true;
        }
        int idx = 0;
        for (Map.Entry<String, EMSColumnAnalysis> columnEntry : columnMap.entrySet()) {
            String propertyName = columnEntry.getKey();
            EMSColumnAnalysis columnAnalysis = columnEntry.getValue();
            PropertyDescriptor property = new PropertyDescriptor(propertyName, object.getClass());
            Method readMethod = property.getReadMethod();
            Object value = null;
            Object temp = readMethod.invoke(object, new Object[0]);
            if (temp == null) continue;
            if (temp instanceof Date) {
                if (isSplit && columnAnalysis.getName().equals(tableAnalysis.getMonth())) {
                    month = sdf.format(temp);
                }
                Timestamp date = new Timestamp(((Date)temp).getTime());
                value = date;
            } else {
                value = temp instanceof Boolean ? (((Boolean)temp).booleanValue() ? Integer.valueOf(1) : Integer.valueOf(0)) : temp;
            }
            if (idx == 0) {
                insertIntoSql.append("(" + columnAnalysis.getName());
                valuesSql.append("(?");
            } else {
                insertIntoSql.append("," + columnAnalysis.getName());
                valuesSql.append(",?");
            }
            paramList.add(value);
            ++idx;
        }
        insertIntoSql.append(")");
        valuesSql.append(")");
        String tableName = BusinessObjectUtils.getTableName(object);
        if (month != null) {
            EmsMonthThread.setTableList(tableName, String.valueOf(month) + "_" + tableName);
            tableName = String.valueOf(month) + "_" + tableName;
        }
        insert.setTable(tableName);
        insert.setSchema(tableAnalysis.getSchema());
    }

    public static String createTableSqlReplace(String createTableSql, String schemaName, String tableNameTemp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String totalTableName = !"".equals(schemaName) ? (String.valueOf(schemaName) + "." + tableNameTemp).toLowerCase() : tableNameTemp.toLowerCase();
        String index = "idx" + sdf.format(new Date()) + "_" + random.nextInt(1000);
        return createTableSql.replace("replace_table", totalTableName).replace("replace_index", index);
    }

    /*
     * Unable to fully structure code
     */
    public static <T extends BusinessObject> T recursiveObject(T object, Map<String, Object> criteria) throws Exception {
        standard = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        cls = object.getClass();
        bi = Introspector.getBeanInfo(cls);
        propertyList = bi.getPropertyDescriptors();
        block2: for (Map.Entry<String, Object> entryCriteria : criteria.entrySet()) {
            criteriaKey = entryCriteria.getKey();
            value = entryCriteria.getValue();
            var13_13 = propertyList;
            var12_12 = propertyList.length;
            var11_11 = 0;
            while (var11_11 < var12_12) {
                block26: {
                    property = var13_13[var11_11];
                    propertyClass = property.getPropertyType();
                    fieldJson = null;
                    try {
                        fieldJson = cls.getDeclaredField(property.getName());
                    }
                    catch (Exception var16_17) {
                        // empty catch block
                    }
                    jp = null;
                    if (fieldJson != null) {
                        jp = fieldJson.getAnnotation(JsonProperty.class);
                    }
                    if (jp == null) break block26;
                    if (!jp.value().equalsIgnoreCase(criteriaKey)) ** GOTO lbl89
                    if (propertyClass == List.class) {
                        type = fieldJson.getGenericType();
                        if (type instanceof ParameterizedType && (obj = (genericClazz = (Class)((ParameterizedType)type).getActualTypeArguments()[0]).newInstance()) instanceof BusinessObject) {
                            ((BusinessObject)obj).setBuildingForContainer(object.getBuildingForContainer());
                            ((BusinessObject)obj).setSplitEnergyType(object.getSplitEnergyType());
                            ((BusinessObject)obj).setSplitTimeType(object.getSplitTimeType());
                            criteriaSub = (Map)((Map)value).get("$elemMatch");
                            writeMethod = property.getWriteMethod();
                            subList = new ArrayList<BusinessObject>();
                            subList.add(BusinessObjectUtils.recursiveObject((BusinessObject)obj, criteriaSub));
                            writeMethod.invoke(object, new Object[]{subList});
                            continue block2;
                        }
                    } else {
                        if (value != null) {
                            if (value instanceof Map) {
                                mapValue = (Map)value;
                                obj = mapValue.entrySet().iterator();
                                while (obj.hasNext()) {
                                    entryValue = obj.next();
                                    temp = entryValue.getValue();
                                    if (propertyClass == Date.class) {
                                        if (temp instanceof List) {
                                            dateList = new ArrayList<Date>();
                                            for (String dateStr : (List)temp) {
                                                date = standard.parse(dateStr);
                                                dateList.add(date);
                                            }
                                            temp = dateList;
                                        } else {
                                            date = standard.parse((String)temp);
                                            temp = date;
                                        }
                                    } else if (propertyClass == Double.class && !(temp instanceof Double)) {
                                        if (temp instanceof List) {
                                            numList = new ArrayList<Double>();
                                            for (E num : (List)temp) {
                                                numList.add(new Double(num.toString()));
                                            }
                                            temp = numList;
                                        } else {
                                            temp = new Double(temp.toString());
                                        }
                                    }
                                    specialOperator = EMSConstant.Operator.getSpecialOperator((String)entryValue.getKey());
                                    if (specialOperator != null) {
                                        object.setSpecialOperation(property.getName(), specialOperator, temp);
                                        continue;
                                    }
                                    throw new RuntimeException(" not support operator ");
                                }
                                continue block2;
                            }
                            temp = value;
                            if (propertyClass == Date.class) {
                                date = standard.parse((String)temp);
                                temp = date;
                            } else if (propertyClass == Double.class && !(temp instanceof Double)) {
                                temp = new Double(temp.toString());
                            }
                            writeMethod = property.getWriteMethod();
                            writeMethod.invoke(object, new Object[]{temp});
                            continue block2;
                        }
                        object.setSpecialOperation(property.getName(), SpecialOperator.$null, null);
                        continue block2;
lbl89:
                        // 1 sources

                        index = criteriaKey.indexOf(".");
                        if (index != -1) {
                            tempField = criteriaKey.substring(0, index);
                            nextCascade = criteriaKey.substring(index + 1);
                            if (jp.value().equalsIgnoreCase(tempField) && propertyClass == List.class && (type = fieldJson.getGenericType()) instanceof ParameterizedType && (obj = (genericClazz = (Class)((ParameterizedType)type).getActualTypeArguments()[0]).newInstance()) instanceof BusinessObject) {
                                ((BusinessObject)obj).setBuildingForContainer(object.getBuildingForContainer());
                                ((BusinessObject)obj).setSplitEnergyType(object.getSplitEnergyType());
                                ((BusinessObject)obj).setSplitTimeType(object.getSplitTimeType());
                                criteriaSub = new LinkedHashMap<String, Object>();
                                criteriaSub.put(nextCascade, value);
                                writeMethod = property.getWriteMethod();
                                subList = new ArrayList<BusinessObject>();
                                subList.add(BusinessObjectUtils.recursiveObject((BusinessObject)obj, criteriaSub));
                                writeMethod.invoke(object, new Object[]{subList});
                                continue block2;
                            }
                        }
                    }
                }
                ++var11_11;
            }
        }
        return object;
    }
}

