/*
 * Decompiled with CFR 0.152.
 */
package com.persagy.core.utils;

import java.io.File;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpUtils {
    private static final CloseableHttpClient httpClient;
    private static final String CHARSET = "UTF-8";

    static {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(1000).setConnectionRequestTimeout(1000).setSocketTimeout(3600000).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(200);
        connectionManager.setDefaultMaxPerRoute(200);
        httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
    }

    public static String post(String url, Map<String, Object> params, Boolean isMultipart) throws Exception {
        CloseableHttpResponse response;
        int statusCode;
        HttpEntity reqEntity = null;
        if (params != null && params.size() > 0) {
            Object obj;
            if (isMultipart != null && isMultipart.booleanValue()) {
                MultipartEntityBuilder meb = MultipartEntityBuilder.create();
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    obj = entry.getValue();
                    FileBody contentBody = null;
                    if (obj instanceof File) {
                        contentBody = new FileBody((File)obj);
                    } else {
                        if (obj instanceof Date) {
                            obj = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)obj);
                        }
                        contentBody = new StringBody(obj.toString(), ContentType.create((String)"text/plain", (Charset)Charset.forName(CHARSET)));
                    }
                    meb.addPart(entry.getKey(), (ContentBody)contentBody);
                }
                reqEntity = meb.build();
            } else {
                ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(params.size());
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    obj = entry.getValue();
                    if (obj instanceof Date) {
                        obj = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)obj);
                    } else if (obj instanceof File) {
                        throw new Exception("please set isMultipart true");
                    }
                    pairs.add(new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
                }
                reqEntity = new UrlEncodedFormEntity(pairs, CHARSET);
            }
        }
        HttpPost httpPost = new HttpPost(url);
        if (reqEntity != null) {
            httpPost.setEntity(reqEntity);
        }
        if ((statusCode = (response = httpClient.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode()) != 200) {
            httpPost.abort();
            throw new RuntimeException("HttpClient,error status code :" + statusCode);
        }
        HttpEntity entity = response.getEntity();
        String result = null;
        if (entity != null) {
            result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
        }
        EntityUtils.consume((HttpEntity)entity);
        response.close();
        return result;
    }

    public static String get(String url, Map<String, String> params) throws Exception {
        HttpGet httpGet;
        CloseableHttpResponse response;
        int statusCode;
        if (params != null && !params.isEmpty()) {
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String value = entry.getValue();
                if (value == null) continue;
                pairs.add(new BasicNameValuePair(entry.getKey(), value));
            }
            url = String.valueOf(url) + "?" + EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(pairs, CHARSET));
        }
        if ((statusCode = (response = httpClient.execute((HttpUriRequest)(httpGet = new HttpGet(url)))).getStatusLine().getStatusCode()) != 200) {
            httpGet.abort();
            throw new RuntimeException("HttpClient,error status code :" + statusCode);
        }
        HttpEntity entity = response.getEntity();
        String result = null;
        if (entity != null) {
            result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
        }
        EntityUtils.consume((HttpEntity)entity);
        response.close();
        return result;
    }

    public static void main(String[] args) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("jsonString", "{}");
        try {
            String result = HttpUtils.post("http://192.168.100.105:8888/EMS_Cloud/Spring/MVC/entrance/unifier/BuildingListService", params, false);
            System.out.println(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

