/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.PackageVersion;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.dataformat.xml.ser.XmlSerializerProvider;
import com.fasterxml.jackson.dataformat.xml.util.DefaultXmlPrettyPrinter;
import com.fasterxml.jackson.dataformat.xml.util.XmlRootNameLookup;

public class XmlMapper
extends ObjectMapper {
    private static final long serialVersionUID = -724333029147285918L;
    protected static final JacksonXmlModule DEFAULT_XML_MODULE = new JacksonXmlModule();
    protected final JacksonXmlModule _xmlModule;

    public XmlMapper() {
        this(new XmlFactory());
    }

    public XmlMapper(XmlFactory xmlFactory) {
        this(xmlFactory, DEFAULT_XML_MODULE);
    }

    public XmlMapper(JacksonXmlModule jacksonXmlModule) {
        this(new XmlFactory(), jacksonXmlModule);
    }

    public XmlMapper(XmlFactory xmlFactory, JacksonXmlModule jacksonXmlModule) {
        super((JsonFactory)xmlFactory, (DefaultSerializerProvider)new XmlSerializerProvider(new XmlRootNameLookup()), null);
        this._xmlModule = jacksonXmlModule;
        if (jacksonXmlModule != null) {
            this.registerModule((Module)jacksonXmlModule);
        }
    }

    public XmlMapper copy() {
        this._checkInvalidCopy(XmlMapper.class);
        return new XmlMapper((XmlFactory)this._jsonFactory.copy(), this._xmlModule);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    protected void setXMLTextElementName(String string) {
        ((XmlFactory)this._jsonFactory).setXMLTextElementName(string);
    }

    @Deprecated
    public XmlFactory getJsonFactory() {
        return (XmlFactory)this._jsonFactory;
    }

    public XmlFactory getFactory() {
        return (XmlFactory)this._jsonFactory;
    }

    public ObjectMapper configure(ToXmlGenerator.Feature feature, boolean bl) {
        ((XmlFactory)this._jsonFactory).configure(feature, bl);
        return this;
    }

    public ObjectMapper configure(FromXmlParser.Feature feature, boolean bl) {
        ((XmlFactory)this._jsonFactory).configure(feature, bl);
        return this;
    }

    public ObjectMapper enable(ToXmlGenerator.Feature feature) {
        ((XmlFactory)this._jsonFactory).enable(feature);
        return this;
    }

    public ObjectMapper enable(FromXmlParser.Feature feature) {
        ((XmlFactory)this._jsonFactory).enable(feature);
        return this;
    }

    public ObjectMapper disable(ToXmlGenerator.Feature feature) {
        ((XmlFactory)this._jsonFactory).disable(feature);
        return this;
    }

    public ObjectMapper disable(FromXmlParser.Feature feature) {
        ((XmlFactory)this._jsonFactory).disable(feature);
        return this;
    }

    protected PrettyPrinter _defaultPrettyPrinter() {
        return new DefaultXmlPrettyPrinter();
    }
}

