/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.deser;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.dataformat.xml.deser.WrapperHandlingDeserializer;
import com.fasterxml.jackson.dataformat.xml.util.AnnotationUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class XmlBeanDeserializerModifier
extends BeanDeserializerModifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String _cfgNameForTextValue = "";

    public XmlBeanDeserializerModifier(String string) {
        this._cfgNameForTextValue = string;
    }

    public List<BeanPropertyDefinition> updateProperties(DeserializationConfig deserializationConfig, BeanDescription beanDescription, List<BeanPropertyDefinition> list) {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        int n = 0;
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            String string;
            PropertyName propertyName;
            BeanPropertyDefinition beanPropertyDefinition = list.get(i);
            AnnotatedMember annotatedMember = beanPropertyDefinition.getPrimaryMember();
            if (annotatedMember == null) continue;
            Boolean bl = AnnotationUtil.findIsTextAnnotation(annotationIntrospector, annotatedMember);
            if (bl != null && bl.booleanValue()) {
                propertyName = beanPropertyDefinition.withName(this._cfgNameForTextValue);
                if (propertyName == beanPropertyDefinition) continue;
                list.set(i, (BeanPropertyDefinition)propertyName);
                continue;
            }
            propertyName = beanPropertyDefinition.getWrapperName();
            if (propertyName == null || propertyName == PropertyName.NO_NAME || (string = propertyName.getSimpleName()) == null || string.length() <= 0 || string.equals(beanPropertyDefinition.getName())) continue;
            if (n == 0) {
                list = new ArrayList<BeanPropertyDefinition>(list);
            }
            ++n;
            list.set(i, beanPropertyDefinition.withName(string));
        }
        return list;
    }

    public JsonDeserializer<?> modifyDeserializer(DeserializationConfig deserializationConfig, BeanDescription beanDescription, JsonDeserializer<?> jsonDeserializer) {
        if (!(jsonDeserializer instanceof BeanDeserializerBase)) {
            return jsonDeserializer;
        }
        return new WrapperHandlingDeserializer((BeanDeserializerBase)jsonDeserializer);
    }
}

