/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.ser;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.dataformat.xml.util.StaxUtil;
import com.fasterxml.jackson.dataformat.xml.util.XmlRootNameLookup;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public class XmlSerializerProvider
extends DefaultSerializerProvider {
    private static final long serialVersionUID = 8525947864862035821L;
    protected static final QName ROOT_NAME_FOR_NULL = new QName("null");
    protected final XmlRootNameLookup _rootNameLookup;

    public XmlSerializerProvider(XmlRootNameLookup xmlRootNameLookup) {
        this._rootNameLookup = xmlRootNameLookup;
    }

    public XmlSerializerProvider(XmlSerializerProvider xmlSerializerProvider, SerializationConfig serializationConfig, SerializerFactory serializerFactory) {
        super((SerializerProvider)xmlSerializerProvider, serializationConfig, serializerFactory);
        this._rootNameLookup = xmlSerializerProvider._rootNameLookup;
    }

    public DefaultSerializerProvider createInstance(SerializationConfig serializationConfig, SerializerFactory serializerFactory) {
        return new XmlSerializerProvider(this, serializationConfig, serializerFactory);
    }

    public void serializeValue(JsonGenerator jsonGenerator, Object object) throws IOException, JsonProcessingException {
        QName qName = object == null ? ROOT_NAME_FOR_NULL : this._rootNameLookup.findRootName(object.getClass(), (MapperConfig<?>)this._config);
        this._initWithRootName(jsonGenerator, qName);
        super.serializeValue(jsonGenerator, object);
    }

    public void serializeValue(JsonGenerator jsonGenerator, Object object, JavaType javaType) throws IOException, JsonProcessingException {
        QName qName = this._rootNameLookup.findRootName(javaType, (MapperConfig<?>)this._config);
        this._initWithRootName(jsonGenerator, qName);
        super.serializeValue(jsonGenerator, object, javaType);
    }

    public void serializeValue(JsonGenerator jsonGenerator, Object object, JavaType javaType, JsonSerializer<Object> jsonSerializer) throws IOException, JsonGenerationException {
        QName qName = this._rootNameLookup.findRootName(javaType, (MapperConfig<?>)this._config);
        this._initWithRootName(jsonGenerator, qName);
        super.serializeValue(jsonGenerator, object, javaType, jsonSerializer);
    }

    protected void _initWithRootName(JsonGenerator jsonGenerator, QName qName) throws IOException, JsonProcessingException {
        ToXmlGenerator toXmlGenerator = (ToXmlGenerator)jsonGenerator;
        if (!toXmlGenerator.setNextNameIfMissing(qName) && toXmlGenerator.getOutputContext().inRoot()) {
            toXmlGenerator.setNextName(qName);
        }
        toXmlGenerator.initGenerator();
        String string = qName.getNamespaceURI();
        if (string != null && string.length() > 0) {
            try {
                toXmlGenerator.getStaxWriter().setDefaultNamespace(string);
            }
            catch (XMLStreamException xMLStreamException) {
                StaxUtil.throwXmlAsIOException(xMLStreamException);
            }
        }
    }
}

