/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.util;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.util.Instantiatable;
import com.fasterxml.jackson.dataformat.xml.XmlPrettyPrinter;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamWriter2;

public class DefaultXmlPrettyPrinter
implements XmlPrettyPrinter,
Instantiatable<DefaultXmlPrettyPrinter>,
Serializable {
    private static final long serialVersionUID = -1811120944652457526L;
    protected Indenter _arrayIndenter = new FixedSpaceIndenter();
    protected Indenter _objectIndenter = new Lf2SpacesIndenter();
    protected boolean _spacesInObjectEntries = true;
    protected transient int _nesting = 0;

    public void indentArraysWith(Indenter indenter) {
        this._arrayIndenter = indenter == null ? new NopIndenter() : indenter;
    }

    public void indentObjectsWith(Indenter indenter) {
        this._objectIndenter = indenter == null ? new NopIndenter() : indenter;
    }

    public void spacesInObjectEntries(boolean bl) {
        this._spacesInObjectEntries = bl;
    }

    public DefaultXmlPrettyPrinter createInstance() {
        return new DefaultXmlPrettyPrinter();
    }

    public void writeRootValueSeparator(JsonGenerator jsonGenerator) throws IOException, JsonGenerationException {
        jsonGenerator.writeRaw('\n');
    }

    public void beforeArrayValues(JsonGenerator jsonGenerator) throws IOException, JsonGenerationException {
    }

    public void writeStartArray(JsonGenerator jsonGenerator) throws IOException, JsonGenerationException {
    }

    public void writeArrayValueSeparator(JsonGenerator jsonGenerator) throws IOException, JsonGenerationException {
    }

    public void writeEndArray(JsonGenerator jsonGenerator, int n) throws IOException, JsonGenerationException {
    }

    public void beforeObjectEntries(JsonGenerator jsonGenerator) throws IOException, JsonGenerationException {
    }

    public void writeStartObject(JsonGenerator jsonGenerator) throws IOException, JsonGenerationException {
        if (!this._objectIndenter.isInline()) {
            if (this._nesting > 0) {
                this._objectIndenter.writeIndentation(jsonGenerator, this._nesting);
            }
            ++this._nesting;
        }
        ((ToXmlGenerator)jsonGenerator)._handleStartObject();
    }

    public void writeObjectEntrySeparator(JsonGenerator jsonGenerator) throws IOException, JsonGenerationException {
    }

    public void writeObjectFieldValueSeparator(JsonGenerator jsonGenerator) throws IOException, JsonGenerationException {
    }

    public void writeEndObject(JsonGenerator jsonGenerator, int n) throws IOException, JsonGenerationException {
        if (!this._objectIndenter.isInline()) {
            --this._nesting;
        }
        if (n > 0) {
            this._objectIndenter.writeIndentation(jsonGenerator, this._nesting);
        }
        ((ToXmlGenerator)jsonGenerator)._handleEndObject();
    }

    @Override
    public void writeStartElement(XMLStreamWriter2 xMLStreamWriter2, String string, String string2) throws XMLStreamException {
        if (!this._objectIndenter.isInline()) {
            if (this._nesting > 0) {
                this._objectIndenter.writeIndentation(xMLStreamWriter2, this._nesting);
            }
            ++this._nesting;
        }
        xMLStreamWriter2.writeStartElement(string, string2);
    }

    @Override
    public void writeEndElement(XMLStreamWriter2 xMLStreamWriter2, int n) throws XMLStreamException {
        if (!this._objectIndenter.isInline()) {
            --this._nesting;
        }
        if (n > 0) {
            this._objectIndenter.writeIndentation(xMLStreamWriter2, this._nesting);
        }
        xMLStreamWriter2.writeEndElement();
    }

    @Override
    public void writeLeafElement(XMLStreamWriter2 xMLStreamWriter2, String string, String string2, String string3) throws XMLStreamException {
        if (!this._objectIndenter.isInline()) {
            this._objectIndenter.writeIndentation(xMLStreamWriter2, this._nesting);
        }
        xMLStreamWriter2.writeStartElement(string, string2);
        xMLStreamWriter2.writeCharacters(string3);
        xMLStreamWriter2.writeEndElement();
    }

    @Override
    public void writeLeafElement(XMLStreamWriter2 xMLStreamWriter2, String string, String string2, char[] cArray, int n, int n2) throws XMLStreamException {
        if (!this._objectIndenter.isInline()) {
            this._objectIndenter.writeIndentation(xMLStreamWriter2, this._nesting);
        }
        xMLStreamWriter2.writeStartElement(string, string2);
        xMLStreamWriter2.writeCharacters(cArray, n, n2);
        xMLStreamWriter2.writeEndElement();
    }

    @Override
    public void writeLeafElement(XMLStreamWriter2 xMLStreamWriter2, String string, String string2, boolean bl) throws XMLStreamException {
        if (!this._objectIndenter.isInline()) {
            this._objectIndenter.writeIndentation(xMLStreamWriter2, this._nesting);
        }
        xMLStreamWriter2.writeStartElement(string, string2);
        xMLStreamWriter2.writeBoolean(bl);
        xMLStreamWriter2.writeEndElement();
    }

    @Override
    public void writeLeafElement(XMLStreamWriter2 xMLStreamWriter2, String string, String string2, int n) throws XMLStreamException {
        if (!this._objectIndenter.isInline()) {
            this._objectIndenter.writeIndentation(xMLStreamWriter2, this._nesting);
        }
        xMLStreamWriter2.writeStartElement(string, string2);
        xMLStreamWriter2.writeInt(n);
        xMLStreamWriter2.writeEndElement();
    }

    @Override
    public void writeLeafElement(XMLStreamWriter2 xMLStreamWriter2, String string, String string2, long l) throws XMLStreamException {
        if (!this._objectIndenter.isInline()) {
            this._objectIndenter.writeIndentation(xMLStreamWriter2, this._nesting);
        }
        xMLStreamWriter2.writeStartElement(string, string2);
        xMLStreamWriter2.writeLong(l);
        xMLStreamWriter2.writeEndElement();
    }

    @Override
    public void writeLeafElement(XMLStreamWriter2 xMLStreamWriter2, String string, String string2, double d) throws XMLStreamException {
        if (!this._objectIndenter.isInline()) {
            this._objectIndenter.writeIndentation(xMLStreamWriter2, this._nesting);
        }
        xMLStreamWriter2.writeStartElement(string, string2);
        xMLStreamWriter2.writeDouble(d);
        xMLStreamWriter2.writeEndElement();
    }

    @Override
    public void writeLeafElement(XMLStreamWriter2 xMLStreamWriter2, String string, String string2, float f) throws XMLStreamException {
        if (!this._objectIndenter.isInline()) {
            this._objectIndenter.writeIndentation(xMLStreamWriter2, this._nesting);
        }
        xMLStreamWriter2.writeStartElement(string, string2);
        xMLStreamWriter2.writeFloat(f);
        xMLStreamWriter2.writeEndElement();
    }

    @Override
    public void writeLeafElement(XMLStreamWriter2 xMLStreamWriter2, String string, String string2, BigInteger bigInteger) throws XMLStreamException {
        if (!this._objectIndenter.isInline()) {
            this._objectIndenter.writeIndentation(xMLStreamWriter2, this._nesting);
        }
        xMLStreamWriter2.writeStartElement(string, string2);
        xMLStreamWriter2.writeInteger(bigInteger);
        xMLStreamWriter2.writeEndElement();
    }

    @Override
    public void writeLeafElement(XMLStreamWriter2 xMLStreamWriter2, String string, String string2, BigDecimal bigDecimal) throws XMLStreamException {
        if (!this._objectIndenter.isInline()) {
            this._objectIndenter.writeIndentation(xMLStreamWriter2, this._nesting);
        }
        xMLStreamWriter2.writeStartElement(string, string2);
        xMLStreamWriter2.writeDecimal(bigDecimal);
        xMLStreamWriter2.writeEndElement();
    }

    @Override
    public void writeLeafElement(XMLStreamWriter2 xMLStreamWriter2, String string, String string2, byte[] byArray, int n, int n2) throws XMLStreamException {
        if (!this._objectIndenter.isInline()) {
            this._objectIndenter.writeIndentation(xMLStreamWriter2, this._nesting);
        }
        xMLStreamWriter2.writeStartElement(string, string2);
        xMLStreamWriter2.writeBinary(byArray, n, n2);
        xMLStreamWriter2.writeEndElement();
    }

    @Override
    public void writeLeafNullElement(XMLStreamWriter2 xMLStreamWriter2, String string, String string2) throws XMLStreamException {
        if (!this._objectIndenter.isInline()) {
            this._objectIndenter.writeIndentation(xMLStreamWriter2, this._nesting);
        }
        xMLStreamWriter2.writeEmptyElement(string, string2);
    }

    protected static class Lf2SpacesIndenter
    implements Indenter {
        static final String SYSTEM_LINE_SEPARATOR;
        static final int SPACE_COUNT = 64;
        static final char[] SPACES;

        @Override
        public boolean isInline() {
            return false;
        }

        @Override
        public void writeIndentation(XMLStreamWriter2 xMLStreamWriter2, int n) throws XMLStreamException {
            xMLStreamWriter2.writeRaw(SYSTEM_LINE_SEPARATOR);
            n += n;
            while (n > 64) {
                xMLStreamWriter2.writeRaw(SPACES, 0, 64);
                n -= SPACES.length;
            }
            xMLStreamWriter2.writeRaw(SPACES, 0, n);
        }

        @Override
        public void writeIndentation(JsonGenerator jsonGenerator, int n) throws IOException, JsonGenerationException {
            jsonGenerator.writeRaw(SYSTEM_LINE_SEPARATOR);
            n += n;
            while (n > 64) {
                jsonGenerator.writeRaw(SPACES, 0, 64);
                n -= SPACES.length;
            }
            jsonGenerator.writeRaw(SPACES, 0, n);
        }

        static {
            String string = null;
            try {
                string = System.getProperty("line.separator");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            SYSTEM_LINE_SEPARATOR = string == null ? "\n" : string;
            SPACES = new char[64];
            Arrays.fill(SPACES, ' ');
        }
    }

    protected static class FixedSpaceIndenter
    implements Indenter {
        @Override
        public void writeIndentation(XMLStreamWriter2 xMLStreamWriter2, int n) throws XMLStreamException {
            xMLStreamWriter2.writeRaw(" ");
        }

        @Override
        public void writeIndentation(JsonGenerator jsonGenerator, int n) throws IOException, JsonGenerationException {
            jsonGenerator.writeRaw(' ');
        }

        @Override
        public boolean isInline() {
            return true;
        }
    }

    protected static class NopIndenter
    implements Indenter {
        @Override
        public void writeIndentation(JsonGenerator jsonGenerator, int n) {
        }

        @Override
        public boolean isInline() {
            return true;
        }

        @Override
        public void writeIndentation(XMLStreamWriter2 xMLStreamWriter2, int n) {
        }
    }

    public static interface Indenter {
        public void writeIndentation(JsonGenerator var1, int var2) throws IOException, JsonGenerationException;

        public void writeIndentation(XMLStreamWriter2 var1, int var2) throws XMLStreamException;

        public boolean isInline();
    }
}

